package org.jeecg.modules.diseaseAnalysis.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 检查批次查询接收类
 * </p>
 *
 * @author hkl
 * @since 2024-07-19
 */
@Getter
@Setter
@ApiModel(value = "EkRecordsMasterCheckDTO对象", description = "检查批次查询接收类")

public class EkRecordsMasterCheckDTO {


    private static final long serialVersionUID = 1L;

    @ApiModelProperty("检查编号")
    private String ekCode;

    @ApiModelProperty("开始时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date startTime;

    @ApiModelProperty("结束时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date endTime;

    @ApiModelProperty("1-道岔检查 2-钢轨常规探伤检查 3-曲线钢轨磨耗检查 4-钢轨波磨检查 5-道床检查 6-线路检查）")
    private String type;

    @ApiModelProperty("线路id")
    private String lightRailId;

    @ApiModelProperty("线别id")
    private String lineAliasId;
}
