package org.jeecg.modules.diseaseAnalysis.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 线路质量分析	-分析批次表
 * </p>
 *
 * @author hkl
 * @since 2024-07-19
 */
@Getter
@Setter
@TableName("t_dsa_analysis_line_batch")
@ApiModel(value = "AnalysisLineBatch对象", description = "线路质量分析	-分析批次表")
public class AnalysisLineBatch implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableId("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    private Date updateTime;

    @ApiModelProperty("分析批次号")
    @TableField("analysis_batch_code")
    private String analysisBatchCode;

    @ApiModelProperty("所属线路id")
    @TableField("light_rail_id")
    private String lightRailId;

    @ApiModelProperty("所属线路名称")
    @TableField("light_rail_name")
    private String lightRailName;

    @ApiModelProperty("所属线别id")
    @TableField("line_alias_id")
    private String lineAliasId;

    @ApiModelProperty("所属线别名称")
    @TableField("line_alias_name")
    private String lineAliasName;

    @ApiModelProperty("分析起始里程")
    @TableField("starting_mileage")
    private BigDecimal startingMileage;

    @ApiModelProperty("分析终点里程")
    @TableField("end_mileage")
    private BigDecimal endMileage;

    @ApiModelProperty("1-道岔检查 2-钢轨常规探伤检查 3-曲线钢轨磨耗检查 4-钢轨波磨检查 5-道床检查 6-线路检查）")
    @TableField("ek_type")
    private String ekType;

    @ApiModelProperty("分析状态 0-创建 1-分析中  99-分析完成")
    @TableField("analysis_status")
    private Integer analysisStatus;

    @ApiModelProperty("备注")
    @TableField("remark")
    private String remark;


}
