package org.jeecg.modules.diseaseAnalysis.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 线路质量分析-分析批次表-单元设备（1个分析批次有多个检查批次，1个检查批次有多个单位设备）
 * </p>
 *
 * @author hkl
 * @since 2024-07-19
 */
@Getter
@Setter
@TableName("t_dsa_analysis_line_batch_unit_device")
@ApiModel(value = "AnalysisLineBatchUnitDevice对象", description = "线路质量分析-分析批次表-单元设备详情（1个分析批次有多个检查批次，1个检查批次有多个单位设备）")
public class AnalysisLineBatchUnitDevice implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableId("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    private Date updateTime;

    @ApiModelProperty("分析批id")
    @TableField("analysis_batch_id")
    private String analysisBatchId;

    @ApiModelProperty("分析批次号")
    @TableField("analysis_batch_code")
    private String analysisBatchCode;

    @ApiModelProperty("检查批次编码")
    @TableField("ek_code")
    private String ekCode;

    @ApiModelProperty("检查批次id")
    @TableField("ek_id")
    private String ekId;

    @ApiModelProperty("单元设备id")
    @TableField("unit_id")
    private String unitId;

    @ApiModelProperty("单元设备code")
    @TableField("unit_code")
    private String unitCode;

    @ApiModelProperty("设备单元类型1-钢轨,2-曲线,3-竖曲线,4-道岔")
    @TableField("unit_type")
    private Integer unitType;

    @ApiModelProperty("设备单元类型名称")
    @TableField("unit_type_name")
    private String unitTypeName;

    @ApiModelProperty("设备编号")
    @TableField("unit_device_code")
    private String unitDeviceCode;

    @ApiModelProperty("设备单元起始里程")
    @TableField("unit_start_mileage")
    private BigDecimal unitStartMileage;

    @ApiModelProperty("设备单元中心里程")
    @TableField("unit_center_mileage")
    private BigDecimal unitCenterMileage;

    @ApiModelProperty("设备单元结束里程")
    @TableField("unit_end_mileage")
    private BigDecimal unitEndMileage;


    @ApiModelProperty("派工状态（1：未派工，2：已派工）")
    @TableField("work_status")
    private Integer workStatus;

    @ApiModelProperty("标记状态(1:未标记，2：异常，3：正常)")
    @TableField("mark_status")
    private Integer markStatus;

    @ApiModelProperty("检查结果:1:正常，2：异常（线路巡查时才有值）")
    @TableField("check_status")
    private Integer checkStatus;

    @ApiModelProperty("备注(同时兼容巡道员备忘录)")
    @TableField("remark")
    private String remark;


}
