package org.jeecg.modules.diseaseAnalysis.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 线路质量分析-分析批次表-单元设备详情（1个分析批次有多个检查批次，1个检查批次有多个单位设备，1个单元设备有多个详情）---钢轨探伤检查
 * </p>
 *
 * @author hkl
 * @since 2024-07-24
 */
@Getter
@Setter
@TableName("t_dsa_analysis_line_batch_unit_device_rail_wear_info")
@ApiModel(value = "AnalysisLineBatchUnitDeviceRailWearInfo对象", description = "线路质量分析-分析批次表-单元设备详情（1个分析批次有多个检查批次，1个检查批次有多个单位设备，1个单元设备有多个详情）---钢轨探伤检查")
public class AnalysisLineBatchUnitDeviceRailWearInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableField("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    private Date updateTime;

    @ApiModelProperty("分析批id")
    @TableField("analysis_batch_id")
    private String analysisBatchId;

    @ApiModelProperty("分析批次号")
    @TableField("analysis_batch_code")
    private String analysisBatchCode;

    @ApiModelProperty("设备检查记录主表id（t_ek_records_master_check）")
    @TableField("ek_id")
    private String ekId;

    @ApiModelProperty("检查批次号（t_ek_records_master_check）")
    @TableField("ek_code")
    private String ekCode;

    @ApiModelProperty("单元表id（t_dsa_analysis_line_batch_unit_device）")
    @TableField("device_id")
    private String deviceId;

    @ApiModelProperty("检查设备id(设备资产四种表的主键)")
    @TableField("device_project_id")
    private String deviceProjectId;

    @ApiModelProperty("检查设备编码(设备资产四种表的unit_code)")
    @TableField("device_project_code")
    private String deviceProjectCode;

    @ApiModelProperty("检查设备类型（1-钢轨,2-曲线,3-竖曲线,4-道岔）")
    @TableField("device_project_type")
    private Integer deviceProjectType;

    @ApiModelProperty("股别(1-左股，2-右股)")
    @TableField("damage_level")
    private Integer damageLevel;

    @ApiModelProperty("伤损钢轨数量")
    @TableField("damage_num")
    private Integer damageNum;

    @ApiModelProperty("伤损种类（1-鱼鳞纹,2-剥落掉块,3-表面疲劳裂纹,4-轨底掉块,5-灼伤,6-核伤,7-焊缝,8-其他）")
    @TableField("damage_type")
    private Integer damageType;

    @ApiModelProperty("伤损里程")
    @TableField("damage_mileage")
    private BigDecimal damageMileage;

    @ApiModelProperty("伤损程度(1-轻伤,2-轻伤有发展,3-重伤)")
    @TableField("damage_degree")
    private Integer damageDegree;

    @ApiModelProperty("换轨计划")
    @TableField("damage_plan")
    private String damagePlan;

    @ApiModelProperty("是否删除（0：未删除，1：已删除）")
    @TableField("del_flag")
    private String delFlag;


}
