package org.jeecg.modules.diseaseAnalysis.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;
import org.jeecg.modules.checkData.dto.CorrugationRecordDTO;
import org.jeecg.modules.checkData.vo.CorrugationRecordVO;
import org.jeecg.modules.diseaseAnalysis.dto.AnalysisLineBatchDTO;
import org.jeecg.modules.diseaseAnalysis.dto.AnalysisLineBatchInfoDTO;
import org.jeecg.modules.diseaseAnalysis.dto.AnalysisLineBatchWorkDTO;
import org.jeecg.modules.diseaseAnalysis.dto.EkRecordsMasterCheckDTO;
import org.jeecg.modules.diseaseAnalysis.entity.AnalysisLineBatch;
import org.jeecg.modules.diseaseAnalysis.vo.*;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 线路质量分析	-分析批次表 Mapper 接口
 * </p>
 *
 * @author hkl
 * @since 2024-07-19
 */
public interface AnalysisLineBatchMapper extends BaseMapper<AnalysisLineBatch> {
    /**
     * 线路质量分析-其他病害分析-检查记录-分页列表查询
     * @param pageData
     * @param dto
     * @return
     */
    Page<EkRecordsMasterCheckVO> queryPageEkList(@Param("pageData")Page<EkRecordsMasterCheckVO> pageData, @Param("dto")EkRecordsMasterCheckDTO dto);

    /**
     * 线路质量分析-其他病害分析-线路巡查检查记录-分页列表查询
     * @param pageData
     * @param dto
     * @return
     */
    Page<EkRecordPatrolMasterVO> queryPageEkPatrolList(@Param("pageData")Page<EkRecordPatrolMasterVO> pageData, @Param("dto")EkRecordsMasterCheckDTO dto);

    /**
     * 线路质量分析-其他病害分析-线路巡查检查记录-分页列表查询
     * @param pageData
     * @param dto
     * @return
     */
    Page<AnalysisLineBatchVO> getPageList(@Param("pageData")Page<AnalysisLineBatchVO> pageData, @Param("dto")AnalysisLineBatchDTO dto);

    /**
     * 获取是否可编辑列表
     * @param analysisBatchIds
     * @return
     */
    List<Map<String, Object>> getIsEditList(List<String> analysisBatchIds);
    /**
     * 获取分析批次对应得检查批次信息
     * @param analysisLineBatchIds 分析批次id集合
     * @return
     */
    List<AnalysisLineBatchCheckDataMapVO> listRecordDetail(List<String> analysisLineBatchIds);

    /**
     * 线路质量分析-其他病害分析-线路巡查检查记录-分页列表查询
     * @param pageData
     * @param dto
     * @return
     */
    Page<AnalysisLineBatchUnitDeviceVO> getInfoPageList(@Param("pageData") Page<AnalysisLineBatchUnitDeviceVO> pageData, @Param("dto")AnalysisLineBatchInfoDTO dto);


    /**
     * 线路质量分析-其他病害分析-详情检查记录查询
     * @param analysisBatchId 分析批次id
     * @param ekId 检查批次id
     * @param deviceId 线路质量分析-其他病害分析-单元表id
     * @return
     */
    List<AnalysisLineBatchUnitDeviceTurnoutInfoVO> getAnalysisLineBatchUnitEkInfoList(@Param("analysisBatchId") String analysisBatchId, @Param("ekId")String ekId, @Param("deviceId")String deviceId);
    /**
     * 线路质量分析-其他病害分析-钢轨探伤单元详情检查记录查询
     * @param analysisBatchId
     * @param ekId
     * @param deviceId
     * @return
     */
    List<AnalysisLineBatchUnitDeviceRailWearInfoVO> getAnalysisLineBatchUnitDeviceRailWearInfoList(@Param("analysisBatchId") String analysisBatchId, @Param("ekId")String ekId, @Param("deviceId")String deviceId);

    /**
     * 线路质量分析-其他病害分析-钢轨波磨单元详情检查记录查询
     * @param analysisBatchId
     * @param ekId
     * @param deviceId
     * @return
     */
    List<AnalysisLineBatchUnitDeviceCorrugationInfoVO> getAnalysisLineBatchUnitDeviceCorrugationInfoList(@Param("analysisBatchId") String analysisBatchId, @Param("ekId")String ekId, @Param("deviceId")String deviceId);
    /**
     * 线路质量分析-其他病害分析-曲线波磨单元详情检查记录查询
     * @param analysisBatchId
     * @param ekId
     * @param deviceId
     * @return
     */
    List<AnalysisLineBatchUnitDeviceCurveWearInfoVO> getAnalysisLineBatchUnitDeviceCurveWearInfoList(@Param("analysisBatchId") String analysisBatchId, @Param("ekId")String ekId, @Param("deviceId")String deviceId);
    /**
     * 线路质量分析-其他病害分析-道床单元详情检查记录查询
     * @param analysisBatchId
     * @param ekId
     * @param deviceId
     * @return
     */
    List<AnalysisLineBatchUnitDeviceTrackBedInfoVO> getAnalysisLineBatchUnitDeviceTrackBedInfoList(@Param("analysisBatchId") String analysisBatchId, @Param("ekId")String ekId, @Param("deviceId")String deviceId);
    /**
     * 线路质量分析-其他病害分析-线路巡查巡道员检查详情
     *
     * @param analysisBatchId 分析批次id
     * @param ekId            检查批次id
     * @param deviceId        线路质量分析-其他病害分析-单元表id
     * @return
     */
    List<AnalysisLineBatchUnitDevicePatrolInfoVO> getAnalysisLineBatchUnitDevicePatrolInfoList(@Param("analysisBatchId") String analysisBatchId, @Param("ekId")String ekId, @Param("deviceId")String deviceId);

    /**
     * 线路质量分析-其他病害分析-线路巡查协助巡道员检查详情
     *
     * @param analysisBatchId 分析批次id
     * @param ekId            检查批次id
     * @param deviceId        线路质量分析-其他病害分析-单元表id
     * @return
     */
    List<AnalysisLineBatchUnitDevicePatrolAssistInfoVO> getAnalysisLineBatchUnitDevicePatrolAssistInfoList(@Param("analysisBatchId") String analysisBatchId, @Param("ekId")String ekId, @Param("deviceId")String deviceId);
    /**
     * 维修作业管理-选择分析批次-列表分页查询
     * @param pageData
     * @param dto
     * @return
     */
    Page<AnalysisLineBatchWorkVO> getWorkPageList(@Param("pageData") Page<AnalysisLineBatchWorkVO> pageData, @Param("dto")AnalysisLineBatchWorkDTO dto);
}
