package org.jeecg.modules.diseaseAnalysis.vo;


import java.math.BigDecimal;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 线路质量分析-分析批次表-单元设备（1个分析批次有多个检查批次，1个检查批次有多个单位设备）
 * </p>
 *
 * @author hkl
 * @since 2024-07-19
 */
@Getter
@Setter
@ApiModel(value = "AnalysisLineBatchUnitDevice对象", description = "线路质量分析-分析批次表-单元设备详情（1个分析批次有多个检查批次，1个检查批次有多个单位设备）")

public class AnalysisLineBatchUnitDeviceVO {


    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建日期")
    private Date createTime;

    @ApiModelProperty("更新人")
    private String updateBy;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("分析批id")
    private String analysisBatchId;

    @ApiModelProperty("分析批次号")
    private String analysisBatchCode;

    @ApiModelProperty("检查批次编码")
    private String ekCode;

    @ApiModelProperty("检查批次id")
    private String ekId;

    @ApiModelProperty("单元设备id")
    private String unitId;

    @ApiModelProperty("单元设备code")
    private String unitCode;

    @ApiModelProperty("设备单元类型1-钢轨,2-曲线,3-竖曲线,4-道岔")
    private Integer unitType;

    @ApiModelProperty("设备单元类型名称")
    private String unitTypeName;

    @ApiModelProperty("设备编号")
    private String unitDeviceCode;

    @ApiModelProperty("设备单元起始里程")
    private BigDecimal unitStartMileage;

    @ApiModelProperty("设备单元中心里程")
    private BigDecimal unitCenterMileage;

    @ApiModelProperty("设备单元结束里程")
    private BigDecimal unitEndMileage;

    @ApiModelProperty("派工状态（1：未派工，2：已派工）")
    private Integer workStatus;

    @ApiModelProperty("标记状态(1:未标记，2：异常，3：正常)")
    private Integer markStatus;

    @ApiModelProperty("检查结果:1:正常，2：异常（线路巡查时才有值）")
    private Integer checkStatus;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("检查日期")
    private Date checkTime;

    @ApiModelProperty("检查人")
    private String checkBy;



}
