package org.jeecg.modules.dynamicStaticAnalysis.controller;


import cn.hutool.core.util.ObjectUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.util.UUIDGenerator;
import org.jeecg.modules.dynamicStaticAnalysis.entity.ConfigAllowValue;
import org.jeecg.modules.dynamicStaticAnalysis.service.IConfigAllowValueService;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 动静态分析-参数配置-容许值差 前端控制器
 * </p>
 *
 * @author hkl
 * @since 2023-08-03
 */
@RestController
@RequestMapping("/dynamicStaticAnalysis/allowValueConfig")
@Api(tags = "动静态分析-参数配置-容许值差")
public class ConfigAllowValueController extends JeecgController<ConfigAllowValue, IConfigAllowValueService> {
    @AutoLog(value = "动静态分析-参数配置-容许值差-查询一条记录")
    @ApiOperation(value = "动静态分析-参数配置-容许值差-查询一条记录", notes = "动静态分析-参数配置-容许值差-查询一条记录")
    @GetMapping(value = "/getOneRecord")
    public Result<ConfigAllowValue> getOneRecord() {
        List<ConfigAllowValue> list = this.service.list();

        if (ObjectUtil.isEmpty(list)) {
            ConfigAllowValue oneRecord = new ConfigAllowValue();
            oneRecord.setId(UUIDGenerator.generate());
            oneRecord.setBigTrackGauge(0);
            oneRecord.setSmallTrackGauge(0);
            oneRecord.setTriangularPit(0);
            oneRecord.setDirection(0);
            oneRecord.setLevel(0);
            oneRecord.setHeight(0);
            oneRecord.setIsWork(1);
            oneRecord.setIsEnable(1);

            this.service.save(oneRecord);
            list.add(oneRecord);
        }

        return Result.OK(list.get(0));
    }


    @AutoLog(value = "动静态分析-参数配置-容许值差-编辑")
    @ApiOperation(value = "动静态分析-参数配置-容许值差-编辑", notes = "动静态分析-参数配置-容许值差-编辑")
    @PostMapping(value = "/updateRecord")
    public Result<String> updateRecord(@RequestBody ConfigAllowValue allowValueConfig) {
        this.service.updateById(allowValueConfig);
        return Result.OK("编辑成功!");
    }
}
