package org.jeecg.modules.dynamicStaticAnalysis.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 动静态分析-分析批次表
 * </p>
 *
 * @author hkl
 * @since 2023-07-26
 */
@Data
@ApiModel(value = "AnalysisBatchQueryDTO对象", description = "动静态分析-分析批次表")
public class AnalysisBatchQueryDTO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("分析批次号")
    private String analysisBatchCode;

    @ApiModelProperty("所属线路id")
    private String lightRailId;

    @ApiModelProperty("所属线别id")
    private String lineAliasId;

    @ApiModelProperty("分析状态 0-创建 1-分析中  99-分析完成")
    private Integer analysisStatus;

    @ApiModelProperty("开始里程")
    private BigDecimal startMileage;

    @ApiModelProperty("结束里程")
    private BigDecimal endMileage;
}
