package org.jeecg.modules.dynamicStaticAnalysis.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
@ApiModel(value = "AnalysisBatchSaveOrUpdateDTO对象", description = "动静态分析-分析批次保存/更新DTO")
public class AnalysisBatchSaveOrUpdateDTO {

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("分析批次号")
    private String analysisBatchCode;

    @ApiModelProperty("所属线路id")
    private String lightRailId;

    @ApiModelProperty("所属线路名称")
    private String lightRailName;

    @ApiModelProperty("所属线别id")
    private String lineAliasId;

    @ApiModelProperty("所属线别名称")
    private String lineAliasName;

    @ApiModelProperty("起始里程")
    private BigDecimal startingMileage;

    @ApiModelProperty("终点里程")
    private BigDecimal endMileage;

    @ApiModelProperty("分析类型 1-均值分析 2-峰值分析")
    private Integer analysisType;

    @ApiModelProperty("评价速度等级字典值")
    private String dictValue;

    @ApiModelProperty("评价速度等级字典名称")
    private String dictLabel;

//    @ApiModelProperty("速度下限")
//    private Integer speedMin;
//
//    @ApiModelProperty("速度上限")
//    private Integer speedMax;

    @ApiModelProperty("容许值差")
    private String allowValue;

    @ApiModelProperty("派工设置")
    private String dispatching;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("检查数据列表")
    private List<CheckDataDTO> checkDataList;

    @Data
    @ApiModel(value = "CheckDataDTO对象", description = "动静态分析-检查数据")
    public static class CheckDataDTO {

        @ApiModelProperty("主键")
        private String id;

        @ApiModelProperty("检查批次号")
        private String ekCode;

        @ApiModelProperty("检查批id")
        private String ekId;

        @ApiModelProperty("检查数据类型")
        private Integer ekType;

        @ApiModelProperty("检查日期")
        @DateTimeFormat(pattern = "yyyy-MM-dd")
        private Date checkTime;

        @ApiModelProperty("起始里程")
        private BigDecimal startingMileage;

        @ApiModelProperty("终点里程")
        private BigDecimal endMileage;

        @ApiModelProperty("备注")
        private String remark;
    }
}
