package org.jeecg.modules.dynamicStaticAnalysis.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 动静态分析-分析批次-检查数据关联关系
 * </p>
 *
 * @author hkl
 * @since 2023-07-26
 */
@Getter
@Setter
@TableName("t_dsa_analysis_batch_check_data_map")
@ApiModel(value = "AnalysisBatchCheckDataMap对象", description = "动静态分析-分析批次-检查数据关联关系")
public class AnalysisBatchCheckDataMap implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableId("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    private Date updateTime;

    @ApiModelProperty("分析批次号")
    @TableField("analysis_batch_code")
    private String analysisBatchCode;

    @ApiModelProperty("分析批id")
    @TableField("analysis_batch_id")
    private String analysisBatchId;

    @ApiModelProperty("检查批次号")
    @TableField("ek_code")
    private String ekCode;

    @ApiModelProperty("检查批id")
    @TableField("ek_id")
    private String ekId;

    @ApiModelProperty("检查数据类型 1-人工静态检查 2-轨检仪静态检查 3-轨检车检查 4-添乘仪检查" )
    @TableField("ek_type")
    private Integer ekType;

    @ApiModelProperty("检查日期")
    @TableField("check_time")
    private Date checkTime;

    @ApiModelProperty("起始里程")
    @TableField("starting_mileage")
    private BigDecimal startingMileage;

    @ApiModelProperty("终点里程")
    @TableField("end_mileage")
    private BigDecimal endMileage;

    @ApiModelProperty("容许值差")
    @TableField("allow_value")
    private String allowValue;

    @ApiModelProperty("派工设置")
    @TableField("dispatching")
    private String dispatching;

    @ApiModelProperty("分析状态 0-创建 1-分析中  99-分析完成")
    @TableField("analysis_status")
    private Integer analysisStatus;

    @ApiModelProperty("备注")
    @TableField("remark")
    private String remark;


}
