package org.jeecg.modules.dynamicStaticAnalysis.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 动静态分析-分析批次-单元设备
 * </p>
 *
 * @author hkl
 * @since 2023-08-03
 */
@Getter
@Setter
@TableName("t_dsa_analysis_batch_unit_device")
@ApiModel(value = "AnalysisBatchUnitDevice对象", description = "动静态分析-分析批次-单元设备")
public class AnalysisBatchUnitDevice implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableId("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    private Date updateTime;

    @ApiModelProperty("分析批次号")
    @TableField("analysis_batch_code")
    private String analysisBatchCode;

    @ApiModelProperty("分析批id")
    @TableField("analysis_batch_id")
    private String analysisBatchId;

    @ApiModelProperty("单元设备id")
    @TableField("unit_id")
    private String unitId;

    @ApiModelProperty("单元设备code")
    @TableField("unit_code")
    private String unitCode;

    @ApiModelProperty("设备单元类型1-钢轨,2-曲线,3-竖曲线,4-道岔")
    @TableField("unit_type")
    private Integer unitType;

    @ApiModelProperty("设备单元类型名称")
    @TableField("unit_type_name")
    private String unitTypeName;

    @ApiModelProperty("设备编号")
    @TableField("unit_device_code")
    private String unitDeviceCode;

    @ApiModelProperty("设备单元起始里程")
    @TableField("unit_start_mileage")
    private BigDecimal unitStartMileage;

    @ApiModelProperty("设备单元中心里程")
    @TableField("unit_center_mileage")
    private BigDecimal unitCenterMileage;

    @ApiModelProperty("设备单元结束里程")
    @TableField("unit_end_mileage")
    private BigDecimal unitEndMileage;

    @ApiModelProperty("单元得分等级 1-优良 2-合格 3-失格")
    @TableField("unit_score_level")
    private Integer unitScoreLevel;

    @ApiModelProperty("单元得分等级说明")
    @TableField("unit_score_level_str")
    private String unitScoreLevelStr;

    @ApiModelProperty("单元得分")
    @TableField("unit_score")
    private BigDecimal unitScore;

    @ApiModelProperty("是否存在人工检查数据 0-不存在 1-存在")
    @TableField("labour_check")
    private Integer labourCheck;

    @ApiModelProperty("人工检查数据得分")
    @TableField("labour_check_score")
    private BigDecimal labourCheckScore;

    @ApiModelProperty("是否存在轨检仪检查数据 0-不存在 1-存在")
    @TableField("rail_device_check")
    private Integer railDeviceCheck;

    @ApiModelProperty("轨检仪检查数据得分")
    @TableField("rail_device_check_score")
    private BigDecimal railDeviceCheckScore;

    @ApiModelProperty("是否存在轨检车查数据 0-不存在 1-存在")
    @TableField("rail_vehicle_check")
    private Integer railVehicleCheck;

    @ApiModelProperty("轨检车查数据得分")
    @TableField("rail_vehicle_check_score")
    private BigDecimal railVehicleCheckScore;

    @ApiModelProperty("是否存在添乘仪查数据 0-不存在 1-存在")
    @TableField("add_device_check")
    private Integer addDeviceCheck;

    @ApiModelProperty("添乘仪查数据得分")
    @TableField("add_device_check_score")
    private BigDecimal addDeviceCheckScore;

    @ApiModelProperty("备注")
    @TableField("remark")
    private String remark;


}
