package org.jeecg.modules.dynamicStaticAnalysis.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 动静态分析-分析批次-单元设备测点得分
 * </p>
 *
 * @author hkl
 * @since 2023-08-28
 */
@Getter
@Setter
@TableName("t_dsa_analysis_batch_unit_device_tqi_score")
@ApiModel(value = "AnalysisBatchUnitDeviceTqiScore对象", description = "动静态分析-分析批次-单元设备测点得分")
public class AnalysisBatchUnitDeviceTqiScore implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableId("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    private Date updateTime;

    @ApiModelProperty("速度下限")
    @TableField("speed_min")
    private Integer speedMin;

    @ApiModelProperty("速度上限")
    @TableField("speed_max")
    private Integer speedMax;

    @ApiModelProperty("分析类型 1-均值分析 2-峰值分析")
    @TableField("analysis_type")
    private Integer analysisType;

    @ApiModelProperty("分析批次单元设备id")
    @TableField("analysis_batch_unit_device_id")
    private String analysisBatchUnitDeviceId;

    @ApiModelProperty("分析批次号")
    @TableField("analysis_batch_code")
    private String analysisBatchCode;

    @ApiModelProperty("分析批id")
    @TableField("analysis_batch_id")
    private String analysisBatchId;

    @ApiModelProperty("单元设备id")
    @TableField("unit_id")
    private String unitId;

    @ApiModelProperty("单元设备code")
    @TableField("unit_code")
    private String unitCode;

    @ApiModelProperty("设备单元类型1-钢轨,2-曲线,3-竖曲线,4-道岔")
    @TableField("unit_type")
    private Integer unitType;

    @ApiModelProperty("设备单元类型名称")
    @TableField("unit_type_name")
    private String unitTypeName;

    @ApiModelProperty("测点类型")
    @TableField("point_type_name")
    private String pointTypeName;

    @ApiModelProperty("高低左")
    @TableField("high_low_left")
    private BigDecimal highLowLeft;

    @ApiModelProperty("高低左分数")
    @TableField("high_low_left_score")
    private BigDecimal highLowLeftScore;

    @ApiModelProperty("高低左权值")
    @TableField("high_low_left_weight_values")
    private BigDecimal highLowLeftWeightValues;

    @ApiModelProperty("高低右")
    @TableField("high_low_right")
    private BigDecimal highLowRight;

    @ApiModelProperty("高低右分数")
    @TableField("high_low_right_score")
    private BigDecimal highLowRightScore;

    @ApiModelProperty("高低右权值")
    @TableField("high_low_right_weight_values")
    private BigDecimal highLowRightWeightValues;

    @ApiModelProperty("轨向左")
    @TableField("track_left")
    private BigDecimal trackLeft;

    @ApiModelProperty("轨向左分数")
    @TableField("track_left_score")
    private BigDecimal trackLeftScore;

    @ApiModelProperty("轨向左权值")
    @TableField("track_left_weight_values")
    private BigDecimal trackLeftWeightValues;

    @ApiModelProperty("轨向右")
    @TableField("track_right")
    private BigDecimal trackRight;

    @ApiModelProperty("轨向右分数")
    @TableField("track_right_score")
    private BigDecimal trackRightScore;

    @ApiModelProperty("轨向右权值")
    @TableField("track_right_weight_values")
    private BigDecimal trackRightWeightValues;

    @ApiModelProperty("水平（mm）")
    @TableField("level")
    private BigDecimal level;

    @ApiModelProperty("水平（mm）分数")
    @TableField("level_score")
    private BigDecimal levelScore;

    @ApiModelProperty("水平（mm）权值")
    @TableField("level_weight_values")
    private BigDecimal levelWeightValues;

    @ApiModelProperty("轨距（mm）")
    @TableField("track_gauge")
    private BigDecimal trackGauge;

    @ApiModelProperty("轨距（mm）分数")
    @TableField("track_gauge_score")
    private BigDecimal trackGaugeScore;

    @ApiModelProperty("轨距（mm）权值")
    @TableField("track_gauge_weight_values")
    private BigDecimal trackGaugeWeightValues;

    @ApiModelProperty("三角坑（mm）")
    @TableField("triangular_pit")
    private BigDecimal triangularPit;

    @ApiModelProperty("三角坑（mm）分数")
    @TableField("triangular_pit_score")
    private BigDecimal triangularPitScore;

    @ApiModelProperty("三角坑（mm）权值")
    @TableField("triangular_pit_weight_values")
    private BigDecimal triangularPitWeightValues;

    @ApiModelProperty("TQI数值")
    @TableField("tqi_come_upon")
    private BigDecimal tqiComeUpon;

    @ApiModelProperty("TQI数值分数")
    @TableField("tqi_come_upon_score")
    private BigDecimal tqiComeUponScore;

    @ApiModelProperty("TQI数值权值")
    @TableField("tqi_come_upon_weight_values")
    private BigDecimal tqiComeUponWeightValues;

    @ApiModelProperty("总得分")
    @TableField("sum_score")
    private BigDecimal sumScore;

    @ApiModelProperty("备注")
    @TableField("remark")
    private String remark;


}
