package org.jeecg.modules.dynamicStaticAnalysis.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 分析批次-动静态几何尺寸-轨检车单元设备映射
 * </p>
 *
 * @author hkl
 * @since 2023-11-30
 */
@Getter
@Setter
@TableName("t_dsa_analysis_over_report_check_unit_device_map")
@ApiModel(value = "AnalysisOverReportCheckUnitDeviceMap对象", description = "分析批次-动静态几何尺寸-轨检车单元设备映射")
public class AnalysisOverReportCheckUnitDeviceMap implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableId("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    private Date updateTime;

    @ApiModelProperty("分析批次单元设备id")
    @TableField("analysis_batch_unit_device_id")
    private String analysisBatchUnitDeviceId;

    @ApiModelProperty("分析批次号")
    @TableField("analysis_batch_code")
    private String analysisBatchCode;

    @ApiModelProperty("分析批id")
    @TableField("analysis_batch_id")
    private String analysisBatchId;

    @ApiModelProperty("设备单元id")
    @TableField("unit_id")
    private String unitId;

    @ApiModelProperty("设备单元编码")
    @TableField("unit_code")
    private String unitCode;

    @ApiModelProperty("设备单元类型1-钢轨,2-曲线,3-竖曲线,4-道岔")
    @TableField("unit_type")
    private Integer unitType;

    @ApiModelProperty("设备单元类型名称")
    @TableField("unit_type_name")
    private String unitTypeName;

    @ApiModelProperty("设备单元起始里程")
    @TableField("unit_starting_mileage")
    private BigDecimal unitStartingMileage;

    @ApiModelProperty("设备单元中心里程")
    @TableField("unit_center_mileage")
    private BigDecimal unitCenterMileage;

    @ApiModelProperty("设备单元终点里程")
    @TableField("unit_end_mileage")
    private BigDecimal unitEndMileage;

    @ApiModelProperty("检查主表id")
    @TableField("check_id")
    private String checkId;

    @ApiModelProperty("检查数据类型 1-人工静态检查 2-轨检仪静态检查 3-轨检车检查 4-添乘仪检查")
    @TableField("check_type")
    private Integer checkType;

    @ApiModelProperty("轨检车超限表id")
    @TableField("over_report_id")
    private String overReportId;

    @ApiModelProperty("超限里程")
    @TableField("over_report_mileage")
    private BigDecimal overReportMileage;

    @ApiModelProperty("超限类型")
    @TableField("over_type")
    private String overType;

    @ApiModelProperty("超限等级")
    @TableField("over_level")
    private Integer overLevel;

    @ApiModelProperty("长度")
    @TableField("longitude")
    private String longitude;

    @ApiModelProperty("峰值（mm或g）")
    @TableField("peak_value")
    private String peakValue;

    @ApiModelProperty("管理数据差")
    @TableField("data_difference")
    private String dataDifference;

    @ApiModelProperty("线性")
    @TableField("xianxing")
    private String xianxing;

    @ApiModelProperty("检查标准")
    @TableField("standard")
    private String standard;

    @ApiModelProperty("速度（km/h）")
    @TableField("spend")
    private String spend;

    @ApiModelProperty("备注")
    @TableField("remark")
    private String remark;


}
