package org.jeecg.modules.dynamicStaticAnalysis.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 动静态分析-参数配置-派工配置
 * </p>
 *
 * @author hkl
 * @since 2023-08-03
 */
@Getter
@Setter
@TableName("t_dsa_config_dispatching")
@ApiModel(value = "ConfigDispatching对象", description = "动静态分析-参数配置-派工配置")
public class ConfigDispatching implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableId("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    private Date updateTime;

    @ApiModelProperty("派工类型 1-静态检查数据 2-轨检车动态检查数据 3-添乘仪动态检查数据")
    @TableField("type")
    private Integer type;

    @ApiModelProperty("派工原因")
    @TableField("reason_label")
    private String reasonLabel;

    @ApiModelProperty("派工code")
    @TableField("reason_value")
    private String reasonValue;

    @ApiModelProperty("是否派工 0-否 1-是(默认值)")
    @TableField("is_work")
    private Integer isWork;

    @ApiModelProperty("是否启用 0-否 1-启用(默认值)")
    @TableField("is_enable")
    private Integer isEnable;


}
