package org.jeecg.modules.dynamicStaticAnalysis.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 动静态分析-配置-单元化管理阈值
 * </p>
 *
 * @author hkl
 * @since 2023-08-01
 */
@Getter
@Setter
@TableName("t_dsa_config_grade_limit")
@ApiModel(value = "ConfigGradeLimit对象", description = "动静态分析-配置-单元化管理阈值")
public class ConfigGradeLimit implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableId("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    private Date updateTime;

    @ApiModelProperty("速度下限")
    @TableField("speed_min")
    private Integer speedMin;

    @ApiModelProperty("速度上限")
    @TableField("speed_max")
    private Integer speedMax;

    @ApiModelProperty("数据字典值")
    @TableField("dict_value")
    private String dictValue;

    @ApiModelProperty("数据字典标签")
    @TableField("dict_label")
    private String dictLabel;

    @ApiModelProperty("评价等级 1-优良 2-合格 3-失格")
    @TableField("grade_level")
    private Integer gradeLevel;

    @ApiModelProperty("评价等级中文说明")
    @TableField("grade_level_str")
    private String gradeLevelStr;

    @ApiModelProperty("最小评分")
    @TableField("grade_min")
    private BigDecimal gradeMin;

    @ApiModelProperty("最大评分")
    @TableField("grade_max")
    private BigDecimal gradeMax;

    @ApiModelProperty("设备类型 1-钢轨  2-曲线  3-竖曲线 4-道岔 ")
    @TableField("device_type")
    private Integer deviceType;

    @ApiModelProperty("是否删除（0：未删除； 1：已删除）")
    @TableField("del_flag")
    private String delFlag;

    @ApiModelProperty("备注")
    @TableField("remark")
    private String remark;


}
