package org.jeecg.modules.dynamicStaticAnalysis.entity;

    import com.baomidou.mybatisplus.annotation.TableField;
    import com.baomidou.mybatisplus.annotation.TableId;
    import com.baomidou.mybatisplus.annotation.TableName;
    import java.io.Serializable;
    import java.math.BigDecimal;
    import java.util.Date;
    import io.swagger.annotations.ApiModel;
    import io.swagger.annotations.ApiModelProperty;
    import lombok.Getter;
    import lombok.Setter;

/**
* <p>
    * 动静态分析-人工检查数据分析批次映射
    * </p>
*
* @author hkl
* @since 2023-11-30
*/
    @Getter
    @Setter
    @ApiModel(value = "AnalysisLabourCheckDataUnitDeviceMap对象", description = "动静态分析-人工检查数据分析批次映射")

public class AnalysisLabourCheckDataUnitDeviceMapDTO {


    private static final long serialVersionUID = 1L;

            @ApiModelProperty("主键")
    private String id;

            @ApiModelProperty("创建人")
    private String createBy;

            @ApiModelProperty("创建日期")
    private Date createTime;

            @ApiModelProperty("更新人")
    private String updateBy;

            @ApiModelProperty("更新时间")
    private Date updateTime;

            @ApiModelProperty("分析批次id")
    private String analysisBatchId;

            @ApiModelProperty("分析批次code")
    private String analysisBatchCode;

            @ApiModelProperty("分析批次单元设备id")
    private String analysisBatchUnitDeviceId;

            @ApiModelProperty("设备单元id")
    private String unitId;

            @ApiModelProperty("设备单元编码")
    private String unitCode;

            @ApiModelProperty("设备单元类型1-钢轨,2-曲线,3-竖曲线,4-道岔")
    private Integer unitType;

            @ApiModelProperty("设备单元类型名称")
    private String unitTypeName;

            @ApiModelProperty("设备单元起始里程")
    private BigDecimal unitStartingMileage;

            @ApiModelProperty("设备单元中心里程")
    private BigDecimal unitCenterMileage;

            @ApiModelProperty("设备单元终点里程")
    private BigDecimal unitEndMileage;

            @ApiModelProperty("检查主表id")
    private String checkId;

            @ApiModelProperty("检查项目id")
    private String checkItemId;

            @ApiModelProperty("检查项目开始里程")
    private BigDecimal checkItemStartingMileage;

            @ApiModelProperty("检查项目结束里程")
    private BigDecimal checkItemEndMileage;

            @ApiModelProperty("检查项目文本")
    private String checkItemText;

            @ApiModelProperty("检查详情id")
    private String checkDetailId;

            @ApiModelProperty("检查详情开始里程")
    private BigDecimal checkDetailStartingMileage;

            @ApiModelProperty("检查详情结束里程")
    private BigDecimal checkDetailEndMileage;

            @ApiModelProperty("测点")
    private Integer measurePoint;

            @ApiModelProperty("轨距")
    private String trackGauge;

            @ApiModelProperty("水平")
    private String level;

            @ApiModelProperty("三角坑")
    private String triangularPit;

            @ApiModelProperty("方向")
    private String direction;

            @ApiModelProperty("高低")
    private String height;

            @ApiModelProperty("结构")
    private String structure;

            @ApiModelProperty("整改")
    private String rectification;

            @ApiModelProperty("备注")
    private String remark;


}
