package org.jeecg.modules.dynamicStaticAnalysis.entity;

    import com.baomidou.mybatisplus.annotation.TableField;
    import com.baomidou.mybatisplus.annotation.TableId;
    import com.baomidou.mybatisplus.annotation.TableName;
    import java.io.Serializable;
    import java.math.BigDecimal;
    import java.util.Date;
    import io.swagger.annotations.ApiModel;
    import io.swagger.annotations.ApiModelProperty;
    import lombok.Getter;
    import lombok.Setter;

/**
* <p>
    * 动静态分析-轨检车-tqi单元总结报告和单元映射关联关系
    * </p>
*
* @author hkl
* @since 2023-11-30
*/
    @Getter
    @Setter
    @ApiModel(value = "AnalysisTqiReportCheckUnitDeviceMap对象", description = "动静态分析-轨检车-tqi单元总结报告和单元映射关联关系")

public class AnalysisTqiReportCheckUnitDeviceMapDTO {


    private static final long serialVersionUID = 1L;

            @ApiModelProperty("主键")
    private String id;

            @ApiModelProperty("创建人")
    private String createBy;

            @ApiModelProperty("创建日期")
    private Date createTime;

            @ApiModelProperty("更新人")
    private String updateBy;

            @ApiModelProperty("更新时间")
    private Date updateTime;

            @ApiModelProperty("分析批次单元设备id")
    private String analysisBatchUnitDeviceId;

            @ApiModelProperty("分析批次号")
    private String analysisBatchCode;

            @ApiModelProperty("分析批id")
    private String analysisBatchId;

            @ApiModelProperty("检查主表id")
    private String checkId;

            @ApiModelProperty("检查数据类型 1-人工静态检查 2-轨检仪静态检查 3-轨检车检查 4-添乘仪检查")
    private Integer checkType;

            @ApiModelProperty("单元id")
    private String unitId;

            @ApiModelProperty("单元code")
    private String unitCode;

            @ApiModelProperty("设备单元类型1-钢轨,2-曲线,3-竖曲线,4-道岔")
    private Integer unitType;

            @ApiModelProperty("设备单元名称")
    private String unitTypeName;

            @ApiModelProperty("设备单元开始里程")
    private BigDecimal unitStartingMileage;

            @ApiModelProperty("设备单元中心里程")
    private BigDecimal unitCenterMileage;

            @ApiModelProperty("设备单元结束里程")
    private BigDecimal unitEndMileage;

            @ApiModelProperty("tqi报告id")
    private String tqiReportId;

            @ApiModelProperty("开始里程(m)")
    private BigDecimal startMileage;

            @ApiModelProperty("终点里程(m)")
    private BigDecimal endMileage;

            @ApiModelProperty("区间名称")
    private String sectionName;

            @ApiModelProperty("高低左")
    private String highLowLeft;

            @ApiModelProperty("高低右")
    private String highLowRight;

            @ApiModelProperty("轨向左")
    private String trackLeft;

            @ApiModelProperty("轨向右")
    private String trackRight;

            @ApiModelProperty("水平（mm）")
    private String level;

            @ApiModelProperty("轨距（mm）")
    private String trackGauge;

            @ApiModelProperty("三角坑（mm）")
    private String triangularPit;

            @ApiModelProperty("TQI数值")
    private String tqiComeUpon;

            @ApiModelProperty("TQI超标")
    private String tqiAboveStandard;

            @ApiModelProperty("扣分")
    private String deduct;

            @ApiModelProperty("检测标准")
    private String standard;

            @ApiModelProperty("速度（km/h）")
    private String spend;


}
