package org.jeecg.modules.dynamicStaticAnalysis.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.jeecg.modules.dynamicStaticAnalysis.dto.AnalysisBatchQueryDTO;
import org.jeecg.modules.dynamicStaticAnalysis.dto.AnalysisBatchSaveOrUpdateDTO;
import org.jeecg.modules.dynamicStaticAnalysis.dto.CheckBatchDTO;
import org.jeecg.modules.dynamicStaticAnalysis.entity.AnalysisBatch;
import com.baomidou.mybatisplus.extension.service.IService;
import org.jeecg.modules.dynamicStaticAnalysis.vo.AnalysisBatchQueryVO;
import org.jeecg.modules.dynamicStaticAnalysis.vo.CheckBatchVO;
import org.jeecg.modules.homePage.dto.DiseaseDTO;
import org.jeecg.modules.homePage.vo.DiseaseVO;
import org.jeecg.modules.homePage.vo.ToDoDetailVO;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 动静态分析-分析批次表 服务类
 * </p>
 *
 * @author hkl
 * @since 2023-07-26
 */
public interface IAnalysisBatchService extends IService<AnalysisBatch> {

    Page<CheckBatchVO> getCheckData(Page<CheckBatchVO> pageData, CheckBatchDTO dto);

    void saveRecord(AnalysisBatchSaveOrUpdateDTO dto);

    void updateRecord(AnalysisBatchSaveOrUpdateDTO dto);

    Page<AnalysisBatchQueryVO> listRecord(Page<AnalysisBatchQueryVO> pageData, AnalysisBatchQueryDTO dto);

    void deleteRecord(String id);

    List<CheckBatchVO> listRecordDetail(List<String> analysisBatchIds);

    List<ToDoDetailVO> getTodoList(String currentUserId);

    List<Map<String, Object>> getIsEditList(List<String> analysisBatchIds);

    /**
     * 病害列表
     *
     * @param analysisBatchId
     * @return
     */
    List<DiseaseVO> diseaseList(String analysisBatchId);
}
