package org.jeecg.modules.dynamicStaticAnalysis.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.jeecg.modules.dynamicStaticAnalysis.dto.AnalysisBatchUnitDeviceDTO;
import org.jeecg.modules.dynamicStaticAnalysis.entity.AnalysisBatchUnitDevice;
import com.baomidou.mybatisplus.extension.service.IService;
import org.jeecg.modules.dynamicStaticAnalysis.vo.AnalysisBatchUnitDeviceVO;
import org.jeecg.modules.unitDevice.vo.RailAddInstrumentCheckVO;
import org.jeecg.modules.unitDevice.vo.RailVehicleCheckVO;
import org.jeecg.modules.unitDevice.vo.RailVehicleTqiVO;
import org.jeecg.modules.unitDevice.vo.StaticCheckVO;

import java.util.List;

/**
 * <p>
 * 动静态分析-分析批次-单元设备 服务类
 * </p>
 *
 * @author hkl
 * @since 2023-08-03
 */
public interface IAnalysisBatchUnitDeviceService extends IService<AnalysisBatchUnitDevice> {

    Page<AnalysisBatchUnitDeviceVO> listRecord(Page<AnalysisBatchUnitDeviceVO> pageData, AnalysisBatchUnitDeviceDTO dto);

    List<StaticCheckVO> getUnitDeviceStaticData(String id);

    List<RailVehicleCheckVO> getUnitDeviceOverReport(String id);

    List<RailVehicleTqiVO> getUnitDeviceTqi(String id);

    List<RailAddInstrumentCheckVO> getUnitDeviceAdditiveInfo(String id);

    List<StaticCheckVO> getLabourCheck(String id);

    List<StaticCheckVO> getRailDeviceCheck(String id);
}
