package org.jeecg.modules.dynamicStaticAnalysis.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.jeecg.common.util.UUIDGenerator;
import org.jeecg.modules.dynamicStaticAnalysis.algorithm.MultiProducer;
import org.jeecg.modules.dynamicStaticAnalysis.dto.AnalysisBatchQueryDTO;
import org.jeecg.modules.dynamicStaticAnalysis.dto.AnalysisBatchSaveOrUpdateDTO;
import org.jeecg.modules.dynamicStaticAnalysis.dto.CheckBatchDTO;
import org.jeecg.modules.dynamicStaticAnalysis.entity.AnalysisBatch;
import org.jeecg.modules.dynamicStaticAnalysis.entity.AnalysisBatchCheckDataMap;
import org.jeecg.modules.dynamicStaticAnalysis.mapper.AnalysisBatchCheckDataMapMapper;
import org.jeecg.modules.dynamicStaticAnalysis.mapper.AnalysisBatchMapper;
import org.jeecg.modules.dynamicStaticAnalysis.service.IAnalysisBatchService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.jeecg.modules.dynamicStaticAnalysis.util.StrUtil;
import org.jeecg.modules.dynamicStaticAnalysis.vo.AnalysisBatchQueryVO;
import org.jeecg.modules.dynamicStaticAnalysis.vo.CheckBatchVO;
import org.jeecg.modules.homePage.dto.DiseaseDTO;
import org.jeecg.modules.homePage.vo.DiseaseVO;
import org.jeecg.modules.homePage.vo.ToDoDetailVO;
import org.jeecg.modules.utils.BeanCopyUtil;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 动静态分析-分析批次表 服务实现类
 * </p>
 *
 * @author hkl
 * @since 2023-07-26
 */
@Service
public class AnalysisBatchServiceImpl extends ServiceImpl<AnalysisBatchMapper, AnalysisBatch> implements IAnalysisBatchService {

    @Resource
    private AnalysisBatchCheckDataMapMapper analysisBatchCheckDataMapMapper;

    @Override
    public Page<CheckBatchVO> getCheckData(Page<CheckBatchVO> pageData, CheckBatchDTO dto) {
        return this.baseMapper.getCheckData(pageData, dto);
    }

    @Override
    public void saveRecord(AnalysisBatchSaveOrUpdateDTO dto) {
        // 主表
        AnalysisBatch analysisBatch = BeanUtil.copyProperties(dto, AnalysisBatch.class);
        analysisBatch.setId(UUIDGenerator.generate());
        analysisBatch.setAnalysisStatus(1); // 1-分析中
        Integer[] speedLevels = StrUtil.getSpeedLevel(dto.getDictLabel());
        analysisBatch.setSpeedMin(speedLevels[0]);
        analysisBatch.setSpeedMax(speedLevels[1]);


        // 明细
        List<AnalysisBatchCheckDataMap> analysisBatchCheckDataMaps = new ArrayList<>();
        List<AnalysisBatchSaveOrUpdateDTO.CheckDataDTO> checkDataList = dto.getCheckDataList();
        for (AnalysisBatchSaveOrUpdateDTO.CheckDataDTO checkDataDTO : checkDataList) {
            AnalysisBatchCheckDataMap analysisBatchCheckDataMap = new AnalysisBatchCheckDataMap();
            analysisBatchCheckDataMap.setId(UUIDGenerator.generate());
            analysisBatchCheckDataMap.setAnalysisBatchId(analysisBatch.getId());
            analysisBatchCheckDataMap.setAnalysisBatchCode(analysisBatch.getAnalysisBatchCode());
            analysisBatchCheckDataMap.setAllowValue(analysisBatch.getAllowValue());
            analysisBatchCheckDataMap.setDispatching(analysisBatch.getDispatching());
            analysisBatchCheckDataMap.setEkCode(checkDataDTO.getEkCode());
            analysisBatchCheckDataMap.setEkId(checkDataDTO.getEkId());
            analysisBatchCheckDataMap.setStartingMileage(checkDataDTO.getStartingMileage());
            analysisBatchCheckDataMap.setEndMileage(checkDataDTO.getEndMileage());
            analysisBatchCheckDataMap.setCheckTime(checkDataDTO.getCheckTime());
            analysisBatchCheckDataMap.setEkType(checkDataDTO.getEkType());
            analysisBatchCheckDataMap.setAnalysisStatus(1);// 分析中
            analysisBatchCheckDataMaps.add(analysisBatchCheckDataMap);
        }

        this.save(analysisBatch);
        for (AnalysisBatchCheckDataMap analysisBatchCheckDataMap : analysisBatchCheckDataMaps) {
            analysisBatchCheckDataMapMapper.insert(analysisBatchCheckDataMap);
        }

        try {
            Thread.sleep(2000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        // 执行分析
        MultiProducer.produce(analysisBatch.getId());
    }

    @Override
    public void updateRecord(AnalysisBatchSaveOrUpdateDTO dto) {
        // 主表
        AnalysisBatch analysisBatch = BeanUtil.copyProperties(dto, AnalysisBatch.class);
        analysisBatch.setAnalysisType(dto.getAnalysisType());
        analysisBatch.setAnalysisStatus(1); // 1-分析中
        Integer[] speedLevels = StrUtil.getSpeedLevel(dto.getDictLabel());
        analysisBatch.setSpeedMin(speedLevels[0]);
        analysisBatch.setSpeedMax(speedLevels[1]);

        // 明细
        // 1.先删除
        LambdaQueryWrapper<AnalysisBatchCheckDataMap> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(AnalysisBatchCheckDataMap::getAnalysisBatchId, analysisBatch.getId());
        analysisBatchCheckDataMapMapper.delete(wrapper);

        // 2.后新增
        List<AnalysisBatchCheckDataMap> analysisBatchCheckDataMaps = new ArrayList<>();
        List<AnalysisBatchSaveOrUpdateDTO.CheckDataDTO> checkDataList = dto.getCheckDataList();
        for (AnalysisBatchSaveOrUpdateDTO.CheckDataDTO checkDataDTO : checkDataList) {
            AnalysisBatchCheckDataMap analysisBatchCheckDataMap = new AnalysisBatchCheckDataMap();
            analysisBatchCheckDataMap.setId(UUIDGenerator.generate());
            analysisBatchCheckDataMap.setAnalysisBatchId(analysisBatch.getId());
            analysisBatchCheckDataMap.setAnalysisBatchCode(analysisBatch.getAnalysisBatchCode());
            analysisBatchCheckDataMap.setAllowValue(analysisBatch.getAllowValue());
            analysisBatchCheckDataMap.setDispatching(analysisBatch.getDispatching());
            analysisBatchCheckDataMap.setEkCode(checkDataDTO.getEkCode());
            analysisBatchCheckDataMap.setEkId(checkDataDTO.getEkId());
            analysisBatchCheckDataMap.setStartingMileage(checkDataDTO.getStartingMileage());
            analysisBatchCheckDataMap.setEndMileage(checkDataDTO.getEndMileage());
            analysisBatchCheckDataMap.setCheckTime(checkDataDTO.getCheckTime());
            analysisBatchCheckDataMap.setEkType(checkDataDTO.getEkType());
            analysisBatchCheckDataMap.setAnalysisStatus(1);// 分析中
            analysisBatchCheckDataMaps.add(analysisBatchCheckDataMap);
        }

        this.updateById(analysisBatch);
        for (AnalysisBatchCheckDataMap analysisBatchCheckDataMap : analysisBatchCheckDataMaps) {
            analysisBatchCheckDataMapMapper.insert(analysisBatchCheckDataMap);
        }


        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        // 执行分析
        MultiProducer.produce(analysisBatch.getId());
    }

    @Override
    public Page<AnalysisBatchQueryVO> listRecord(Page<AnalysisBatchQueryVO> pageData, AnalysisBatchQueryDTO dto) {

        return this.baseMapper.listRecord(pageData, dto);
    }

    @Override
    public void deleteRecord(String id) {
        // 1.先删除明细
        LambdaQueryWrapper<AnalysisBatchCheckDataMap> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(AnalysisBatchCheckDataMap::getAnalysisBatchId, id);
        analysisBatchCheckDataMapMapper.delete(wrapper);


        // 2.删除主信息
        this.removeById(id);
    }

    @Override
    public List<CheckBatchVO> listRecordDetail(List<String> analysisBatchIds) {
        return this.baseMapper.listRecordDetail(analysisBatchIds);
    }

    @Override
    public List<ToDoDetailVO> getTodoList(String currentUserId) {
        return this.baseMapper.getTodoList(currentUserId);
    }

    @Override
    public List<Map<String, Object>> getIsEditList(List<String> analysisBatchIds) {
        return this.baseMapper.getIsEditList(analysisBatchIds);
    }

    @Override
    public List<DiseaseVO> diseaseList(String analysisBatchId) {
        return this.baseMapper.diseaseList(analysisBatchId);
    }


}
