package org.jeecg.modules.dynamicStaticAnalysis.service.impl;

import org.jeecg.modules.dynamicStaticAnalysis.entity.ConfigRailVehicleCheck;
import org.jeecg.modules.dynamicStaticAnalysis.mapper.ConfigRailVehicleCheckMapper;
import org.jeecg.modules.dynamicStaticAnalysis.service.IConfigRailVehicleCheckService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 动静态分析-配置-轨检车检查超限权值 服务实现类
 * </p>
 *
 * @author hkl
 * @since 2023-08-01
 */
@Service
public class ConfigRailVehicleCheckServiceImpl extends ServiceImpl<ConfigRailVehicleCheckMapper, ConfigRailVehicleCheck> implements IConfigRailVehicleCheckService {


    /**
     * 获取json资源path
     */
    public String getResourcePath() {
        String jsonPath = "org/jeecg/modules/dynamicStaticAnalysis/template";
        return Thread.currentThread().getContextClassLoader().getResource(jsonPath).getPath();
    }

    @Override
    public List<ConfigRailVehicleCheck> listRecord() {
        List<ConfigRailVehicleCheck> records = this.lambdaQuery().eq(ConfigRailVehicleCheck::getDelFlag, "0").list();
        return records;
    }
}
