package org.jeecg.modules.dynamicStaticAnalysis.util;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 字符串工具类
 */
public class StrUtil {

    /**
     * @param expressions
     * @return 返回一个速度等级数组:Integer[] speedLevel = new Integer[2]<br/>
     * 其中 speedLevel[0]速度下限制,speedLevel[1] 速度上限
     */
    public static Integer[] getSpeedLevel(String expressions) {
        if (null == expressions) {
            return null;
        }
        Integer[] speedLevel = new Integer[2];

        String regex = "\\d+";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(expressions);
        int i = 0;
        while (matcher.find()) {
            speedLevel[i] = Integer.valueOf(matcher.group());
            i++;
        }

        return speedLevel;
    }


    /**
     * 提取文字成数字并去掉末尾多余的0
     *
     * @param text
     * @return
     */
    public static BigDecimal extractTextToNumber(String text) {
        String regex = "(-\\|+)?\\d+(\\.\\d+)?";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(text);
        BigDecimal result = null;
        while (matcher.find()) {
            String group = matcher.group();
            if (null != group && !group.isEmpty()) {
                result = new BigDecimal(group);
                break;
            }
        }
        return result;
    }

}
