package org.jeecg.modules.dynamicStaticAnalysis.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 动静态分析-分析批次表
 * </p>
 *
 * @author hkl
 * @since 2023-07-26
 */
@Data
@ApiModel(value = "AnalysisBatchQueryVO对象", description = "动静态分析-分析批次表")
public class AnalysisBatchQueryVO {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("更新人")
    private String updateBy;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("分析批次号")
    private String analysisBatchCode;

    @ApiModelProperty("所属线路id")
    private String lightRailId;

    @ApiModelProperty("所属线路名称")
    private String lightRailName;

    @ApiModelProperty("所属线别id")
    private String lineAliasId;

    @ApiModelProperty("所属线别名称")
    private String lineAliasName;

    @ApiModelProperty("起始里程")
    private BigDecimal startingMileage;

    @ApiModelProperty("终点里程")
    private BigDecimal endMileage;

    @ApiModelProperty("分析类型 1-均值分析 2-峰值分析")
    private Integer analysisType;

    @ApiModelProperty("评价速度等级字典值")
    private String dictValue;

    @ApiModelProperty("评价速度等级字典名称")
    private String dictLabel;

    @ApiModelProperty("容许值差")
    private String allowValue;

    @ApiModelProperty("派工设置")
    private String dispatching;

    @ApiModelProperty("分析状态 0-创建 1-分析中  99-分析完成")
    private Integer analysisStatus;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("是否可以编辑 ture-可编辑  false-不可编辑")
    private boolean isEdit;

    @ApiModelProperty("动静态分析-检查批次VO")
    private List<CheckBatchVO> checkBatchList;
}
