package org.jeecg.modules.dynamicStaticAnalysis.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 动静态分析-分析批次表
 * </p>
 *
 * @author hkl
 * @since 2023-07-26
 */
@Data
@ApiModel(value = "AnalysisBatchUnitDeviceTransfiniteVO对象", description = "动静态分析-分析批次-单元设备-超限列表")
public class AnalysisBatchUnitDeviceTransfiniteVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("分析批次单元设备id")
    private String analysisBatchUnitDeviceId;

    @ApiModelProperty("超限等级")
    private Integer transfiniteGrade;

    @ApiModelProperty("超限等级名称")
    private String transfiniteGradeName;

    @ApiModelProperty("超限类型")
    private String transfiniteType;

    @ApiModelProperty("容许值")
    private String allowValue;

    @ApiModelProperty("测点值")
    private String measurePointValue;

    @ApiModelProperty("是否派工 0-否 1-是")
    private Integer isWork;

    @ApiModelProperty("病害里程")
    private BigDecimal diseaseMileage;

    @ApiModelProperty("备注")
    private String remark;
}
