package org.jeecg.modules.dynamicStaticAnalysis.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/*
 *
 *@author hkl
 *@since 2023-07-26
 */
@Data
@ApiModel(value = "CheckBatchVO对象", description = "动静态分析-检查批次VO")
public class CheckBatchVO {

    @ApiModelProperty("分析批次id")
    private String analysisBatchId;

    @ApiModelProperty("检查id")
    private String ekId;

    @ApiModelProperty("检查批次编号")
    private String ekCode;

    @ApiModelProperty("检查类型")
    private Integer ekType;

    @ApiModelProperty("所属线路id")
    private String lightRailId;

    @ApiModelProperty("所属线路名称")
    private String lightRailName;

    @ApiModelProperty("所属线别id")
    private String lineAliasId;

    @ApiModelProperty("所属线别名称")
    private String lineAliasName;

    @ApiModelProperty("起始里程")
    private BigDecimal startingMileage;

    @ApiModelProperty("终点里程")
    private BigDecimal endMileage;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("检查人姓名")
    private String checkBy;

    @ApiModelProperty("检查日期")
    private Date checkTime;

    @ApiModelProperty("审核人姓名")
    private String verifyBy;

    @ApiModelProperty("审核时间")
    private Date verifyTime;
}
