package org.jeecg.modules.homePage.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.modules.homePage.dto.DiseaseDTO;
import org.jeecg.modules.homePage.face.HomePageFace;
import org.jeecg.modules.homePage.vo.DiseaseVO;
import org.jeecg.modules.homePage.vo.ToDoVO;
import org.jeecg.modules.homePage.vo.HomeSearchInfoVO;
import org.jeecg.modules.subwayNetwork.vo.SectionStationNode;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * <p>
 * 首页 前端控制器
 * </p>
 *
 * @author hkl
 * @since 2023-09-25 16:45:26
 */
@RestController
@RequestMapping("/homePage")
@Api(tags = "首页")
public class HomePageController {

    @Resource
    private HomePageFace homePageFace;

    @AutoLog(value = "首页-获取检索信息")
    @ApiOperation(value = "首页-获取检索信息", notes = "首页-获取检索信息")
    @GetMapping(value = "/searchInfo")
    public Result<List<HomeSearchInfoVO>> searchInfo(String query) {
        return Result.OK(homePageFace.searchInfo(query));
    }

    @AutoLog(value = "首页-获取线路下面所有的(区间-站点)树-弃用")
    @ApiOperation(value = "首页-获取线路下面所有的(区间-站点)树-弃用", notes = "首页-获取线路下面所有的(区间-站点)树")
    @GetMapping(value = "/getTree")
    public Result<List<SectionStationNode>> getTree() {
        return Result.OK(homePageFace.getTree());
    }


    @AutoLog(value = "首页-代办列表")
    @ApiOperation(value = "首页-代办列表", notes = "首页-代办列表")
    @GetMapping(value = "/todoList")
    public Result<ToDoVO> todoList() {

        ToDoVO vo = homePageFace.todoList();
        return Result.OK(vo);
    }

    @AutoLog(value = "首页-病害列表")
    @ApiOperation(value = "首页-病害列表", notes = "首页-病害列表")
    @PostMapping(value = "/diseaseList")
    public Result<List<DiseaseVO>> diseaseList(@RequestBody DiseaseDTO dto) {

        List<DiseaseVO> voList = homePageFace.diseaseList(dto);

        return Result.OK(voList);
    }


}
