package org.jeecg.modules.homePage.face.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import org.jeecg.modules.checkData.service.IMovementRecordsMasterService;
import org.jeecg.modules.dynamicStaticAnalysis.entity.AnalysisBatch;
import org.jeecg.modules.dynamicStaticAnalysis.service.IAnalysisBatchService;
import org.jeecg.modules.homePage.dto.DiseaseDTO;
import org.jeecg.modules.homePage.face.HomePageFace;
import org.jeecg.modules.homePage.vo.DiseaseVO;
import org.jeecg.modules.homePage.vo.ToDoDetailVO;
import org.jeecg.modules.homePage.vo.ToDoVO;
import org.jeecg.modules.maintenanceWork.service.IWorkBatchService;
import org.jeecg.modules.subwayNetwork.service.ILightRailService;
import org.jeecg.modules.homePage.vo.HomeSearchInfoVO;
import org.jeecg.modules.subwayNetwork.vo.SectionStationNode;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class HomePageFaceImpl implements HomePageFace {


    @Resource
    private ILightRailService lightRailService;

    @Resource
    private IMovementRecordsMasterService movementRecordsMasterService;

    @Resource
    private IAnalysisBatchService analysisBatchService;

    @Resource
    private IWorkBatchService workBatchService;


    @Override
    public List<SectionStationNode> getTree() {
        return lightRailService.getTree();
    }


    @Override
    public ToDoVO todoList() {
        String currentUserId = null;
        ToDoVO vo = new ToDoVO();

        // 1.查询检查未使用的检查批次
        List<ToDoDetailVO> checkBatchList = movementRecordsMasterService.getTodoList(currentUserId);
        vo.setCheckBatchList(checkBatchList);


        // 2.查询未派工的分析批次&待派工分析结果列表数据中存在不需要派工的记录
        List<ToDoDetailVO> analysisBatchList = analysisBatchService.getTodoList(currentUserId);
        vo.setAnalysisBatchList(analysisBatchList);


        // 3.查询作业状态未完成的维修派工批次
        List<ToDoDetailVO> workBatchList = workBatchService.getTodoList(currentUserId);
        vo.setWorkBatchList(workBatchList);
        return vo;
    }

    @Override
    public List<DiseaseVO> diseaseList(DiseaseDTO dto) {

        AnalysisBatch one = analysisBatchService.lambdaQuery()
                .orderByDesc(AnalysisBatch::getUpdateTime)
                .last("limit 1")
                .one();
        if (one == null) {
            return new ArrayList<>();
        }


        List<DiseaseVO> records = analysisBatchService.diseaseList(one.getId());
        for (DiseaseVO record : records) {
            record.setLineAliasId(one.getLineAliasId());
            if (one.getLineAliasId().equals("1")) {
                record.setLineAliasCode("SDK");
            } else {
                record.setLineAliasCode("XDK");
            }
        }

        if (ObjectUtil.isNotEmpty(records)) {
            records = conditionalFilter(records, dto);
        }


        // 单独处理管理数据差字段
        for (DiseaseVO record : records) {
            // 峰值是否全是数字
            String dataDifference;
            if (record.getPeakValue().matches("\\d+(\\.\\d+)?")) {
                BigDecimal peakValue = Convert.toBigDecimal(record.getPeakValue());
                BigDecimal longitude = Convert.toBigDecimal(record.getLongitude());
                BigDecimal difference = peakValue.subtract(longitude);
                dataDifference = difference.toString();
            } else {
                dataDifference = record.getLongitude();
            }
            record.setDataDifference(dataDifference);

        }


        return records;
    }

    @Override
    public List<HomeSearchInfoVO> searchInfo(String query) {

        List<HomeSearchInfoVO> voList = lightRailService.searchInfo(query);
        return voList;
    }

    /**
     * 条件过滤
     *
     * @param records
     * @param dto
     */
    private List<DiseaseVO> conditionalFilter(List<DiseaseVO> records, DiseaseDTO dto) {
        Set<Integer> overTypeSet = dto.getOverType();
        overTypeSet.add(3);// 3-轨检车检查
        overTypeSet.add(4);// 4-添乘仪检查
        // 1. 过滤检查类型
        if (ObjectUtil.isNotEmpty(records)) {
            records = records.stream()
                    .filter(v -> overTypeSet.contains(v.getEkType()))
                    .collect(Collectors.toList());
        }


        // 轨检车超限
        Set<Integer> overCardSet = dto.getOverCard();
        // 2.过滤轨检车相关数据
        if (ObjectUtil.isNotEmpty(records)) {
            records = records.stream().filter(v -> v.getEkType() != 3 || overCardSet.contains(v.getOverrunLevel()))
                    .collect(Collectors.toList());
        }


        // 添乘仪-水平超限
        Set<Integer> hSet = dto.getH();
        if (ObjectUtil.isNotEmpty(records)) {
            records = records.stream()
                    .filter(v -> v.getEkType() != 4 || (v.getDiseaseTypeName().equals("水平超限") && hSet.contains(v.getOverrunLevel())))
                    .collect(Collectors.toList());
        }

        // 添乘仪-垂直超限
        Set<Integer> vSet = dto.getV();
        if (ObjectUtil.isNotEmpty(records)) {
            records = records.stream()
                    .filter(v -> v.getEkType() != 4 || (v.getDiseaseTypeName().equals("垂直超限") && vSet.contains(v.getOverrunLevel())))
                    .collect(Collectors.toList());
        }

        return records;
    }
}
