package org.jeecg.modules.maintenanceWork.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 维修作业---线路巡查协助巡道员详情
 * </p>
 *
 * @author hkl
 * @since 2024-08-05
 */
@Getter
@Setter
@ApiModel(value = "WorkBatchDetailPatrolAssistInfo对象", description = "维修作业---线路巡查协助巡道员详情")

public class WorkBatchDetailPatrolAssistInfoDTO {


    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建日期")
    private Date createTime;

    @ApiModelProperty("更新人")
    private String updateBy;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("分析批id")
    private String analysisBatchId;

    @ApiModelProperty("分析批次号")
    private String analysisBatchCode;

    @ApiModelProperty("设备检查记录主表id（t_ek_records_master_check、t_xd_record_patrol_master）")
    private String ekId;

    @ApiModelProperty("检查批次号（t_ek_records_master_check）")
    private String ekCode;

    @ApiModelProperty("单元表id（t_dsa_analysis_line_batch_unit_device）")
    private String deviceId;

    @ApiModelProperty("维修作业主表id")
    private String workId;

    @ApiModelProperty("维修作业单元表id")
    private String workDetailId;

    @ApiModelProperty("巡查区间id")
    private String subwaySectionId;

    @ApiModelProperty("巡查区间名称")
    private String subwaySectionName;

    @ApiModelProperty("线别id")
    private String lineAliasId;

    @ApiModelProperty("线别名称")
    private String lineAliasName;

    @ApiModelProperty("起始里程")
    private BigDecimal startingMileage;

    @ApiModelProperty("终点里程")
    private BigDecimal endMileage;

    @ApiModelProperty("问题记录")
    private String problemRecord;

    @ApiModelProperty("处理情况")
    private String handingLog;

    @ApiModelProperty("整改说明")
    private String reformRemark;

    @ApiModelProperty("是否删除（0：未删除，1：已删除）")
    private String delFlag;


}
