package org.jeecg.modules.maintenanceWork.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 维修作业管理-作业计划批次管理表
 * </p>
 *
 * @author hkl
 * @since 2023-08-09
 */
@Getter
@Setter
@TableName("t_mw_work_batch")
@ApiModel(value = "WorkBatch对象", description = "维修作业管理-作业计划批次管理表")
public class WorkBatch implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableId("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    private Date updateTime;

    @ApiModelProperty("作业计划批次号")
    @TableField("work_batch_code")
    private String workBatchCode;

    @ApiModelProperty("所属线路id")
    @TableField("light_rail_id")
    private String lightRailId;

    @ApiModelProperty("所属线路名称")
    @TableField("light_rail_name")
    private String lightRailName;

    @ApiModelProperty("所属线别id")
    @TableField("line_alias_id")
    private String lineAliasId;

    @ApiModelProperty("所属线别名称")
    @TableField("line_alias_name")
    private String lineAliasName;

    @ApiModelProperty("作业起始里程")
    @TableField("work_start_mileage")
    private BigDecimal workStartMileage;

    @ApiModelProperty("作业终点里程")
    @TableField("work_end_mileage")
    private BigDecimal workEndMileage;

    @ApiModelProperty("作业起始时间")
    @TableField("work_start_time")
    private Date workStartTime;

    @ApiModelProperty("作业终止时间")
    @TableField("work_end_time")
    private Date workEndTime;

    @ApiModelProperty("作业班组")
    @TableField("team")
    private String team;

    @ApiModelProperty("分析类型（0-动静态分析 1-道岔分析 2-钢轨常规探伤分析 3-曲线钢轨磨耗分析 4-钢轨波磨分析 5-道床检查分析 6-线路巡查分析）")
    @TableField("analysis_type")
    private Integer analysisType;

    @ApiModelProperty("作业类型（1-单元方式 2-分析批次方式）")
    @TableField("work_type")
    private Integer workType;

    @ApiModelProperty("来源 1-页面添加 2-超限派工添加")
    @TableField("source")
    private Integer source;

    @ApiModelProperty("作业状态 0-未作业 9-已作业")
    @TableField("work_status")
    private Integer workStatus;

    @ApiModelProperty("是否删除 0-未删除 1-已删除")
    @TableField("del_flag")
    private String delFlag;


}
