package org.jeecg.modules.maintenanceWork.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 维修作业---曲线波磨检查
 * </p>
 *
 * @author hkl
 * @since 2024-08-05
 */
@Getter
@Setter
@TableName("t_mw_work_batch_detail_curve_wear_info")
@ApiModel(value = "WorkBatchDetailCurveWearInfo对象", description = "维修作业---曲线波磨检查")
public class WorkBatchDetailCurveWearInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableField("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    private Date updateTime;

    @ApiModelProperty("分析批id")
    @TableField("analysis_batch_id")
    private String analysisBatchId;

    @ApiModelProperty("分析批次号")
    @TableField("analysis_batch_code")
    private String analysisBatchCode;

    @ApiModelProperty("设备检查记录主表id（t_ek_records_master_check）")
    @TableField("ek_id")
    private String ekId;

    @ApiModelProperty("检查批次号（t_ek_records_master_check）")
    @TableField("ek_code")
    private String ekCode;

    @ApiModelProperty("单元表id（t_dsa_analysis_line_batch_unit_device）")
    @TableField("device_id")
    private String deviceId;

    @ApiModelProperty("维修作业主表id")
    @TableField("work_id")
    private String workId;

    @ApiModelProperty("维修作业单元表id")
    @TableField("work_detail_id")
    private String workDetailId;

    @ApiModelProperty("检查设备id(设备资产四种表的主键)")
    @TableField("device_project_id")
    private String deviceProjectId;

    @ApiModelProperty("检查设备编码(设备资产四种表的unit_code)")
    @TableField("device_project_code")
    private String deviceProjectCode;

    @ApiModelProperty("检查设备类型（1-钢轨,2-曲线,3-竖曲线,4-道岔）")
    @TableField("device_project_type")
    private Integer deviceProjectType;

    @ApiModelProperty("曲线半径")
    @TableField("curve_radius")
    private BigDecimal curveRadius;

    @ApiModelProperty("曲线超高")
    @TableField("curve_super_high")
    private BigDecimal curveSuperHigh;

    @ApiModelProperty("缓和曲线长度")
    @TableField("transition_curve_high")
    private BigDecimal transitionCurveHigh;

    @ApiModelProperty("圆曲线长")
    @TableField("curve_tangent_len")
    private BigDecimal curveTangentLen;

    @ApiModelProperty("圆曲转向（1：左 2：右）")
    @TableField("curve_turn")
    private String curveTurn;

    @ApiModelProperty("检查类型（1：垂直磨耗 2：侧面磨耗）")
    @TableField("curve_type")
    private Integer curveType;

    @ApiModelProperty("2H")
    @TableField("two_num")
    private BigDecimal twoNum;

    @ApiModelProperty("HY")
    @TableField("hy_num")
    private BigDecimal hyNum;

    @ApiModelProperty("HZ")
    @TableField("hz_num")
    private BigDecimal hzNum;

    @ApiModelProperty("QZ")
    @TableField("qz_num")
    private BigDecimal qzNum;

    @ApiModelProperty("YH")
    @TableField("yh_num")
    private BigDecimal yhNum;

    @ApiModelProperty("超限记录类型(1:无，2：轻伤，3：重伤)")
    @TableField("over_type")
    private Integer overType;

    @ApiModelProperty("整改备注")
    @TableField("reform_remark")
    private String reformRemark;

    @ApiModelProperty("是否删除（0：未删除，1：已删除）")
    @TableField("del_flag")
    private String delFlag;


}
