package org.jeecg.modules.maintenanceWork.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 维修作业---线路巡查巡道员详情
 * </p>
 *
 * @author hkl
 * @since 2024-08-05
 */
@Getter
@Setter
@TableName("t_mw_work_batch_detail_patrol_info")
@ApiModel(value = "WorkBatchDetailPatrolInfo对象", description = "维修作业---线路巡查巡道员详情")
public class WorkBatchDetailPatrolInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableField("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    private Date updateTime;

    @ApiModelProperty("分析批id")
    @TableField("analysis_batch_id")
    private String analysisBatchId;

    @ApiModelProperty("分析批次号")
    @TableField("analysis_batch_code")
    private String analysisBatchCode;

    @ApiModelProperty("设备检查记录主表id（t_ek_records_master_check、t_xd_record_patrol_master）")
    @TableField("ek_id")
    private String ekId;

    @ApiModelProperty("检查批次号（t_ek_records_master_check）")
    @TableField("ek_code")
    private String ekCode;

    @ApiModelProperty("单元表id（t_dsa_analysis_line_batch_unit_device）")
    @TableField("device_id")
    private String deviceId;

    @ApiModelProperty("维修作业主表id")
    @TableField("work_id")
    private String workId;

    @ApiModelProperty("维修作业单元表id")
    @TableField("work_detail_id")
    private String workDetailId;

    @ApiModelProperty("检查项目名称")
    @TableField("ek_project_name")
    private String ekProjectName;

    @ApiModelProperty("重点检查项目内容")
    @TableField("ek_project_content")
    private String ekProjectContent;

    @ApiModelProperty("问题记录")
    @TableField("problem_record")
    private String problemRecord;

    @ApiModelProperty("处理情况")
    @TableField("handing_log")
    private String handingLog;

    @ApiModelProperty("是否满足（1：是；2：否）")
    @TableField("status")
    private String status;

    @ApiModelProperty("排序")
    @TableField("seq")
    private Integer seq;

    @ApiModelProperty("备忘录")
    @TableField("remark")
    private String remark;

    @ApiModelProperty("整改备注")
    @TableField("reform_remark")
    private String reformRemark;

    @ApiModelProperty("是否删除（0：未删除，1：已删除）")
    @TableField("del_flag")
    private String delFlag;


}
