package org.jeecg.modules.maintenanceWork.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 维修作业---道床检查
 * </p>
 *
 * @author hkl
 * @since 2024-08-05
 */
@Getter
@Setter
@TableName("t_mw_work_batch_detail_track_bed_info")
@ApiModel(value = "WorkBatchDetailTrackBedInfo对象", description = "维修作业---道床检查")
public class WorkBatchDetailTrackBedInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    @TableField("id")
    private String id;

    @ApiModelProperty("创建人")
    @TableField("create_by")
    private String createBy;

    @ApiModelProperty("创建日期")
    @TableField("create_time")
    private Date createTime;

    @ApiModelProperty("更新人")
    @TableField("update_by")
    private String updateBy;

    @ApiModelProperty("更新时间")
    @TableField("update_time")
    private Date updateTime;

    @ApiModelProperty("分析批id")
    @TableField("analysis_batch_id")
    private String analysisBatchId;

    @ApiModelProperty("分析批次号")
    @TableField("analysis_batch_code")
    private String analysisBatchCode;

    @ApiModelProperty("设备检查记录主表id（t_ek_records_master_check）")
    @TableField("ek_id")
    private String ekId;

    @ApiModelProperty("检查批次号（t_ek_records_master_check）")
    @TableField("ek_code")
    private String ekCode;

    @ApiModelProperty("单元表id（t_dsa_analysis_line_batch_unit_device）")
    @TableField("device_id")
    private String deviceId;

    @ApiModelProperty("维修作业主表id")
    @TableField("work_id")
    private String workId;

    @ApiModelProperty("维修作业单元表id")
    @TableField("work_detail_id")
    private String workDetailId;

    @ApiModelProperty("道床id")
    @TableField("track_bed_id")
    private String trackBedId;

    @ApiModelProperty("道床编号")
    @TableField("track_bed_code")
    private String trackBedCode;

    @ApiModelProperty("道床类型")
    @TableField("track_bed_type")
    private String trackBedType;

    @ApiModelProperty("道床起点里程")
    @TableField("starting_mileage")
    private BigDecimal startingMileage;

    @ApiModelProperty("道床终点里程")
    @TableField("end_mileage")
    private BigDecimal endMileage;

    @ApiModelProperty("道床长度")
    @TableField("track_bed_len")
    private BigDecimal trackBedLen;

    @ApiModelProperty("检查项目名称")
    @TableField("ek_project_name")
    private String ekProjectName;

    @ApiModelProperty("检查项目内容")
    @TableField("ek_project_content")
    private String ekProjectContent;

    @ApiModelProperty("检查合格评判标准")
    @TableField("ek_project_template")
    private String ekProjectTemplate;

    @ApiModelProperty("现场检查项目状态（1：合格；2：良好；3：不合格）")
    @TableField("ek_project_status")
    private String ekProjectStatus;

    @ApiModelProperty("整改备注")
    @TableField("reform_remark")
    private String reformRemark;

    @ApiModelProperty("是否删除（0：未删除，1：已删除）")
    @TableField("del_flag")
    private String delFlag;


}
