package org.jeecg.modules.maintenanceWork.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.jeecg.modules.diseaseAnalysis.entity.AnalysisLineBatchUnitDevicePatrolAssistInfo;
import org.jeecg.modules.diseaseAnalysis.vo.*;
import org.jeecg.modules.dynamicStaticAnalysis.vo.AnalysisBatchUnitDeviceTransfiniteVO;
import org.jeecg.modules.homePage.vo.ToDoDetailVO;
import org.jeecg.modules.maintenanceWork.dto.*;
import org.jeecg.modules.maintenanceWork.entity.WorkBatch;
import com.baomidou.mybatisplus.extension.service.IService;
import org.jeecg.modules.maintenanceWork.vo.*;
import org.jeecg.modules.unitDevice.dto.CaseReportCheckDataDTO;
import org.jeecg.modules.unitDevice.dto.CaseReportWorkBatchDTO;
import org.jeecg.modules.unitDevice.vo.CaseReportCheckDataVO;
import org.jeecg.modules.unitDevice.vo.CaseReportWorkBatchVO;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 维修作业管理-作业计划批次管理表 服务类
 * </p>
 *
 * @author hkl
 * @since 2023-08-09
 */
public interface IWorkBatchService extends IService<WorkBatch> {

    Page<WorkBatchVO> listRecord(Page<WorkBatchVO> pageData, WorkBatchDTO dto);

    /**
     * 动静态超限数据查询
     * @param analysisBatchUnitDeviceId
     * @return
     */
    List<AnalysisBatchUnitDeviceTransfiniteVO> getTransfiniteList(String analysisBatchUnitDeviceId);

    /**
     * 道岔
     * @param analysisBatchId 分析批次id
     * @param analysisBatchUnitDeviceId 分析单元id
     * @return
     */
    List<AnalysisLineBatchUnitDeviceTurnoutInfoVO> getAnalysisLineBatchUnitEkInfoList(String analysisBatchId,String analysisBatchUnitDeviceId);

    /**
     * 钢轨伤损
     * @param analysisBatchId 分析批次id
     * @param analysisBatchUnitDeviceId 分析单元id
     * @return
     */
    List<AnalysisLineBatchUnitDeviceRailWearInfoVO> getAnalysisLineBatchUnitDeviceRailWearInfoList(String analysisBatchId, String analysisBatchUnitDeviceId);
    /**
     * 曲线磨耗检查
     * @param analysisBatchId 分析批次id
     * @param analysisBatchUnitDeviceId 分析单元id
     * @return
     */
    List<AnalysisLineBatchUnitDeviceCurveWearInfoVO> getAnalysisLineBatchUnitDeviceCurveWearInfoList(String analysisBatchId, String analysisBatchUnitDeviceId);
    /**
     * 钢轨波磨检查
     * @param analysisBatchId 分析批次id
     * @param analysisBatchUnitDeviceId 分析单元id
     * @return
     */
    List<AnalysisLineBatchUnitDeviceCorrugationInfoVO> getAnalysisLineBatchUnitDeviceCorrugationInfoList(String analysisBatchId, String analysisBatchUnitDeviceId);
    /**
     * 道床检查
     * @param analysisBatchId 分析批次id
     * @param analysisBatchUnitDeviceId 分析单元id
     * @return
     */
    List<AnalysisLineBatchUnitDeviceTrackBedInfoVO> getAnalysisLineBatchUnitDeviceTrackBedInfoList(String analysisBatchId, String analysisBatchUnitDeviceId);

    /**
     * 线路巡查
     * @param analysisBatchId 分析批次id
     * @param analysisBatchUnitDeviceId 分析单元id
     * @return
     */
    List<AnalysisLineBatchUnitDevicePatrolInfoVO> getAnalysisLineBatchUnitDevicePatrolInfoList(String analysisBatchId, String analysisBatchUnitDeviceId);

    /**
     * 协助线路巡查
     * @param analysisBatchId 分析批次id
     * @param analysisBatchUnitDeviceId 分析单元id
     * @return
     */
    List<AnalysisLineBatchUnitDevicePatrolAssistInfoVO> getAnalysisLineBatchUnitDevicePatrolAssistInfoList(String analysisBatchId, String analysisBatchUnitDeviceId);


    void saveRecord(WorkBatchSaveOrUpdateDTO dto);


    void deleteRecord(String id);

    void transfiniteSaveRecord(WorkBatchTransfiniteSaveDTO dto);


    Page<Map<String, Object>> getUnitDevicePage(Page<Map<String, Object>> pageData, UnitDeviceDTO dto);

    void batchSaveRecord(AnalysisBatchSaveDTO dto);

    Page<CaseReportWorkBatchVO> caseReportWorkBatch(Page<CaseReportWorkBatchVO> pageData, CaseReportWorkBatchDTO dto);

    List<ToDoDetailVO> getTodoList(String currentUserId);

    List<WorkBatchUserVO> listUser(String query);

    /**
     * 整改道岔
     * @param workId 维修主表id
     * @param workInfoId 维修单元表id
     * @return
     */
    List<WorkBatchDetailTurnoutInfoVO> getWorkBatchDetailTurnoutInfoList(String workId, String workInfoId);

    /**
     * 整改钢轨伤损
     * @param workId 维修主表id
     * @param workInfoId 维修单元表id
     * @return
     */
    List<WorkBatchDetailRailWearInfoVO> getWorkBatchDetailRailWearInfoList(String workId, String workInfoId);
    /**
     * 整改曲线磨耗
     * @param workId 维修主表id
     * @param workInfoId 维修单元表id
     * @return
     */
    List<WorkBatchDetailCurveWearInfoVO> getWorkBatchDetailCurveWearInfoList(String workId, String workInfoId);
    /**
     * 整改钢轨波磨
     * @param workId 维修主表id
     * @param workInfoId 维修单元表id
     * @return
     */
    List<WorkBatchDetailCorrugationInfoVO> getWorkBatchDetailCorrugationInfoList(String workId, String workInfoId);
    /**
     * 整改道床
     * @param workId 维修主表id
     * @param workInfoId 维修单元表id
     * @return
     */
    List<WorkBatchDetailTrackBedInfoVO> getWorkBatchDetailTrackBedInfoList(String workId, String workInfoId);

    /**
     * 整改线路巡查
     * @param workId 维修主表id
     * @param workInfoId 维修单元表id
     * @return
     */
    List<WorkBatchDetailPatrolInfoVO> getWorkBatchDetailPatrolInfoList(String workId, String workInfoId);

    /**
     * 整改协助线路巡查
     * @param workId 维修主表id
     * @param workInfoId 维修单元表id
     * @return
     */
    List<WorkBatchDetailPatrolAssistInfoVO> getWorkBatchDetailPatrolAssistInfoList(String workId, String workInfoId);

}
