package org.jeecg.modules.maintenanceWork.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * <p>
 * 动静态几何尺寸对应得里程相关信息详情表
 * </p>
 *
 * @author hkl
 * @since 2023-09-12
 */
@Data
public class WorkBatchDetailModifyVO implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("作业计划批次id")
    private String workBatchId;

    @ApiModelProperty("作业计划批次code")
    private String workBatchCode;

    @ApiModelProperty("作业计划详情id")
    private String workBatchDetailId;

    @ApiModelProperty("单元设备id")
    private String unitId;

    @ApiModelProperty("单元设备code")
    private String unitCode;

    @ApiModelProperty("设备单元类型1-钢轨,2-曲线,3-竖曲线,4-道岔")
    private Integer unitType;

    @ApiModelProperty("设备单元类型名称")
    private String unitTypeName;

    @ApiModelProperty("设备编号")
    private String unitDeviceCode;

    @ApiModelProperty("设备单元起始里程")
    private BigDecimal unitStartMileage;

    @ApiModelProperty("设备单元中心里程")
    private BigDecimal unitCenterMileage;

    @ApiModelProperty("设备单元结束里程")
    private BigDecimal unitEndMileage;

    @ApiModelProperty("测点")
    private Integer measurePoint;

    @ApiModelProperty("轨距")
    private String trackGauge;

    @ApiModelProperty("水平")
    private String level;

    @ApiModelProperty("三角坑")
    private String triangularPit;

    @ApiModelProperty("方向")
    private String direction;

    @ApiModelProperty("高低")
    private String height;

    @ApiModelProperty("结构")
    private String structure;

    @ApiModelProperty("整改")
    private String rectification;
}
