package org.jeecg.modules.ping;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 
 * @Description: 健康检查
 */
@RestController
public class PingController {
    @Value("${spring.application.name:'server name'}")
    private String serverName;

    /**
     * 
     * @Title: success
     * @date 2021年8月30日
     * @author 孙菁
     * @Description: 定期扫描此接口确保服务的连通性
     * @return
     */
    @GetMapping("/ping")
    public String success() {
        return serverName + " pong";
    }
}
