package org.jeecg.modules.statisticAnalysis.service.impl;

import cn.hutool.core.convert.Convert;
import io.swagger.annotations.ApiModelProperty;
import org.jeecg.modules.statisticAnalysis.mapper.StatisticAnalysisMapper;
import org.jeecg.modules.statisticAnalysis.service.StatisticAnalysisService;
import org.jeecg.modules.statisticAnalysis.vo.DynamicGeometryVO;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 统计分析
 */
@Service
public class StatisticAnalysisServiceImpl implements StatisticAnalysisService {

    @Resource
    private StatisticAnalysisMapper statisticAnalysisMapper;

    @Override
    public List<DynamicGeometryVO> dynamicGeometry(String year) {
        List<DynamicGeometryVO> volist = new ArrayList<>();

        List<Map<String, Object>> records = statisticAnalysisMapper.getDynamicGeometry(year);
        Map<String, DynamicGeometryVO> recordMap = new HashMap<>();
        for (Map<String, Object> record : records) {
            // 线路
            String lightRailName = Convert.toStr(record.get("lightRailName"));
            // 检查月份
            Integer checkMonth = Convert.toInt(record.get("checkMonth"));
            // 检查得分
            BigDecimal deductAveSum = Convert.toBigDecimal(record.get("deductAveSum"));
            // 当月检查次数
            Integer checkNum = Convert.toInt(record.get("checkNum"));


            DynamicGeometryVO currentVo = recordMap.get(lightRailName);
            if (null == currentVo) {
                currentVo = new DynamicGeometryVO();

                // 检查线路名称
                currentVo.setLightRailName(lightRailName);

                // 检查数据其他对象以防其他的时候要用
                List<DynamicGeometryVO.CheckData> checkDataList = new ArrayList<>();
                currentVo.setCheckDataList(checkDataList);


                recordMap.put(lightRailName, currentVo);


                volist.add(currentVo);
            }

            // 存放数据对象
            List<DynamicGeometryVO.CheckData> checkDataList = currentVo.getCheckDataList();
            DynamicGeometryVO.CheckData checkData = new DynamicGeometryVO.CheckData();
            checkData.setCheckMonth(checkMonth);
            checkData.setDeductAveSum(deductAveSum);
            checkData.setCheckNum(checkNum);
            checkDataList.add(checkData);
        }

        return volist;
    }
}
