package org.jeecg.modules.statisticAnalysis.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
@ApiModel(value = "DynamicGeometryVO对象", description = "统计分析-线网动态几何尺寸扣分走势图")
public class DynamicGeometryVO {

    @ApiModelProperty("线路名称")
    private String lightRailName;

    @ApiModelProperty("检查数据12月个数据")
    private List<CheckData> checkDataList;

    @ApiModelProperty("检查数据列表")
    private BigDecimal[] deductAveSumArray;

    @Data
    @ApiModel(value = "DynamicGeometryVO$CheckData对象", description = "统计分析-线网动态几何尺寸扣分走势图-检查数据")
    public static class CheckData {
        @ApiModelProperty("检查月份")
        private Integer checkMonth;

        @ApiModelProperty("得分统计")
        private BigDecimal deductAveSum;

        @ApiModelProperty("当月检查次数")
        private Integer checkNum;
    }

}
