package org.jeecg.modules.subwayNetwork.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Description: 线路车站-地铁区间
 * @Author: jeecg-boot
 * @Date: 2023-06-15
 * @Version: V1.0
 */
@Data
@TableName("t_sn_subway_section")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "t_sn_subway_section对象", description = "线路车站-地铁区间")
public class SubwaySection implements Serializable {
    private static final long serialVersionUID = 1L;

    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "主键")
    private java.lang.String id;

    @ApiModelProperty(value = "创建人")
    private java.lang.String createBy;

    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private java.util.Date createTime;

    @ApiModelProperty(value = "更新人")
    private java.lang.String updateBy;

    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private java.util.Date updateTime;

    @ApiModelProperty(value = "区间名")
    private java.lang.String sectionName;

    @ApiModelProperty(value = "区间code")
    private java.lang.String sectionCode;

    @ApiModelProperty(value = "轻轨线路ID")
    private String lightRailId;

    @ApiModelProperty(value = "轻轨线路Name")
    private String lightRailName;

    @ApiModelProperty(value = "起始车站Id")
    private String startTrainStationId;

    @ApiModelProperty(value = "结束车站Id")
    private String endTrainStationId;

    @ApiModelProperty("所属线别id")
    private String lineAliasId;

    @ApiModelProperty(value = "区间起始里程")
    private BigDecimal sectionStartingMileage;

    @ApiModelProperty(value = "区间结束里程")
    private BigDecimal sectionEndMileage;

    @ApiModelProperty(value = "备注")
    private String remark;
}
