package org.jeecg.modules.subwayNetwork.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import org.jeecg.common.api.dto.PageSearch;
import org.jeecg.modules.homePage.vo.HomeSearchInfoVO;
import org.jeecg.modules.subwayNetwork.dto.LightRailQueryDTO;
import org.jeecg.modules.subwayNetwork.entity.LightRail;
import com.baomidou.mybatisplus.extension.service.IService;
import org.jeecg.modules.subwayNetwork.vo.LightRailQueryVO;
import org.jeecg.modules.subwayNetwork.vo.SectionStationMapVO;
import org.jeecg.modules.subwayNetwork.vo.SectionStationNode;

import java.util.List;
import java.util.Map;

/**
 * @Description: 线路车站-轻轨线路
 * @Author: jeecg-boot
 * @Date: 2023-06-14
 * @Version: V1.0
 */
public interface ILightRailService extends IService<LightRail> {

    /**
     * 分页查询
     *
     * @param dto
     * @return
     */
    IPage<LightRailQueryVO> queryPageList(PageSearch<LightRailQueryDTO> dto);

    List<SectionStationMapVO> getSectionStation();

    List<SectionStationNode> getTree();

    List<HomeSearchInfoVO> searchInfo(String query);
}
