package org.jeecg.modules.subwayNetwork.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

@Data
@ApiModel(value = "区间VO")
public class SubwaySectionVO {
    @ApiModelProperty(value = "主键")
    private String id;

    @ApiModelProperty(value = "创建人")
    private String createBy;

    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建日期")
    private Date createTime;

    @ApiModelProperty(value = "更新人")
    private String updateBy;

    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "更新日期")
    private Date updateTime;

    @ApiModelProperty(value = "轻轨线路ID")
    private String lightRailId;

    @ApiModelProperty(value = "轻轨线路名称")
    private String lightRailName;

    @ApiModelProperty(value = "起始车站Id")
    private String startTrainStationId;

    @ApiModelProperty(value = "结束车站Id")
    private String endTrainStationId;

    @ApiModelProperty(value = "区间名")
    private String sectionName;

    @ApiModelProperty(value = "区间里程")
    private BigDecimal sectionMileage;

    @ApiModelProperty(value = "车站数量")
    private Integer trainStationNum;

    @ApiModelProperty("所属线别id")
    private String lineAliasId;

    @ApiModelProperty("所属线别名称")
    private String lineAliasName;

    @ApiModelProperty(value = "区间起始里程")
    private BigDecimal sectionStartingMileage;

    @ApiModelProperty(value = "区间结束里程")
    private BigDecimal sectionEndMileage;

    @ApiModelProperty(value = "备注")
    private String remark;

}
