package org.jeecg.modules.unitDevice.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.modules.unitDevice.dto.CaseReportCheckDataDTO;
import org.jeecg.modules.unitDevice.dto.CaseReportUnitScoreDTO;
import org.jeecg.modules.unitDevice.dto.CaseReportWorkBatchDTO;
import org.jeecg.modules.unitDevice.dto.CaseReportWorkBatchDetailDTO;
import org.jeecg.modules.unitDevice.face.IUnitDeviceFace;
import org.jeecg.modules.unitDevice.vo.*;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

@Slf4j
@RestController
@RequestMapping("/unitDevice/")
@Api(tags = "单元设备")
public class UnitDeviceController {

    @Resource
    private IUnitDeviceFace unitDeviceFace;


    @AutoLog(value = "单元设备-检查数据列表")
    @ApiOperation(value = "单元设备-检查数据列表", notes = "单元设备-检查数据列表")
    @GetMapping(value = "/queryPageList")
    public Result<IPage<CaseReportCheckDataVO>> queryPageList(@RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                                              @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                                              CaseReportCheckDataDTO dto) {
        Page<CaseReportCheckDataVO> pageData = new Page<>(pageNo, pageSize);
        pageData = unitDeviceFace.queryPageList(pageData, dto);
        return Result.OK(pageData);
    }


    @AutoLog(value = "单元设备-设备病历本检查数据")
    @ApiOperation(value = "单元设备-设备病历本检查数据", notes = "单元设备-设备病历本检查数据")
    @GetMapping(value = "/caseReportCheckData")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "unitId", value = "设备ID", required = true),
            @ApiImplicitParam(name = "unitType", value = "设备类型 1-钢轨 2-曲线 3-竖曲线 4-道岔 ", required = true),
            @ApiImplicitParam(name = "checkId", value = "检查id", required = true)
    })
    public Result<CaseReportCheckDataDetailVO> caseReportCheckData(String unitId, int unitType, String checkId) {

        CaseReportCheckDataDetailVO vo = unitDeviceFace.caseReportCheckData(unitId, unitType, checkId);

        return Result.OK(vo);
    }


    @AutoLog(value = "单元设备-设备病历本-单元得分列表")
    @ApiOperation(value = "单元设备-设备病历本-单元得分列表", notes = "单元设备-设备病历本-单元得分列表")
    @GetMapping(value = "/caseReportUnitScore")
    public Result<List<CaseReportUnitScoreVO>> caseReportUnitScore(CaseReportUnitScoreDTO dto) {

        List<CaseReportUnitScoreVO> vo = unitDeviceFace.caseReportUnitScore(dto);

        return Result.OK(vo);
    }


    @AutoLog(value = "单元设备-设备病历本-作业批次列表")
    @ApiOperation(value = "单元设备-设备病历本-作业批次列表", notes = "单元设备-设备病历本-作业批次列表")
    @GetMapping(value = "/caseReportWorkBatch")
    public Result<IPage<CaseReportWorkBatchVO>> caseReportWorkBatch(@RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                                                    @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                                                    CaseReportWorkBatchDTO dto) {
        Page<CaseReportWorkBatchVO> pageData = new Page<>(pageNo, pageSize);
        pageData = unitDeviceFace.caseReportWorkBatch(pageData, dto);
        return Result.OK(pageData);
    }


}
