package org.jeecg.modules.unitDevice.face.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.jeecg.modules.checkData.service.IMovementAdditiveInfoUnitDeviceMapService;
import org.jeecg.modules.checkData.service.IMovementCheckDataUnitDeviceMapService;
import org.jeecg.modules.checkData.service.IMovementOverReportUnitDeviceMapService;
import org.jeecg.modules.checkData.service.IMovementTqiReportUnitDeviceMapService;
import org.jeecg.modules.dynamicStaticAnalysis.entity.AnalysisBatchUnitDevice;
import org.jeecg.modules.dynamicStaticAnalysis.service.IAnalysisBatchUnitDeviceService;
import org.jeecg.modules.maintenanceWork.service.IWorkBatchDetailService;
import org.jeecg.modules.maintenanceWork.service.IWorkBatchService;
import org.jeecg.modules.unitDevice.dto.CaseReportCheckDataDTO;
import org.jeecg.modules.unitDevice.dto.CaseReportUnitScoreDTO;
import org.jeecg.modules.unitDevice.dto.CaseReportWorkBatchDTO;
import org.jeecg.modules.unitDevice.dto.CaseReportWorkBatchDetailDTO;
import org.jeecg.modules.unitDevice.face.IUnitDeviceFace;
import org.jeecg.modules.unitDevice.vo.*;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;

@Service
public class UnitDeviceFaceImpl implements IUnitDeviceFace {

    @Resource
    private IMovementCheckDataUnitDeviceMapService movementCheckDataUnitDeviceMapService;

    @Resource
    private IMovementAdditiveInfoUnitDeviceMapService movementAdditiveInfoUnitDeviceMapService;

    @Resource
    private IMovementOverReportUnitDeviceMapService movementOverReportUnitDeviceMapService;

    @Resource
    private IMovementTqiReportUnitDeviceMapService movementTqiReportUnitDeviceMapService;

    @Resource
    private IAnalysisBatchUnitDeviceService analysisBatchUnitDeviceService;

    @Resource
    private IWorkBatchService workBatchService;

    @Resource
    private IWorkBatchDetailService workBatchDetailService;

    @Override
    public CaseReportCheckDataDetailVO caseReportCheckData(String unitId, int unitType, String checkId) {
        CaseReportCheckDataDetailVO vo = new CaseReportCheckDataDetailVO();


        // 查询人工记录数据
        List<StaticCheckVO> labourCheckVOList = movementCheckDataUnitDeviceMapService.getUnitDeviceData(unitId, unitType, 1, checkId);
        vo.setLabourCheckVOList(labourCheckVOList);


        // 查询轨检仪记录数据
        List<StaticCheckVO> railDeviceCheckVOList = movementCheckDataUnitDeviceMapService.getUnitDeviceData(unitId, unitType, 2, checkId);
        vo.setRailDeviceCheckVOList(railDeviceCheckVOList);


        // 查询轨检车超限记录数据
        List<RailVehicleCheckVO> railVehicleCheckVOList = movementOverReportUnitDeviceMapService.getUnitDeviceData(unitId, unitType, checkId);
        vo.setRailVehicleCheckVOList(railVehicleCheckVOList);


        // 查询轨检车TQI记录数据
        List<RailVehicleTqiVO> railVehicleTqiVOList = movementTqiReportUnitDeviceMapService.getUnitDeviceData(unitId, unitType, checkId);
        vo.setRailVehicleTqiVOList(railVehicleTqiVOList);


        // 添乘仪记录数据
        List<RailAddInstrumentCheckVO> railAddInstrumentCheckVOList = movementAdditiveInfoUnitDeviceMapService.getUnitDeviceData(unitId, unitType, checkId);
        vo.setRailAddInstrumentCheckVOList(railAddInstrumentCheckVOList);


        return vo;
    }

    @Override
    public Page<CaseReportCheckDataVO> queryPageList(Page<CaseReportCheckDataVO> pageData, CaseReportCheckDataDTO dto) {
        return movementCheckDataUnitDeviceMapService.queryUnitDeviceCheckRel(pageData, dto);
    }

    @Override
    public List<CaseReportUnitScoreVO> caseReportUnitScore(CaseReportUnitScoreDTO dto) {

        List<AnalysisBatchUnitDevice> records = analysisBatchUnitDeviceService.lambdaQuery()
                .eq(AnalysisBatchUnitDevice::getUnitId, dto.getUnitId())
                .eq(AnalysisBatchUnitDevice::getUnitType, dto.getUnitType())
                .ge(AnalysisBatchUnitDevice::getCreateTime, dto.getStartTime())
                .le(AnalysisBatchUnitDevice::getCreateTime, dto.getEndTime())
                .ne(AnalysisBatchUnitDevice::getUnitScore, -1)
                .orderByAsc(AnalysisBatchUnitDevice::getCreateTime).list();

        List<CaseReportUnitScoreVO> results = new ArrayList<>();
        if (ObjectUtil.isNotEmpty(records)) {
            for (AnalysisBatchUnitDevice record : records) {
                CaseReportUnitScoreVO result = new CaseReportUnitScoreVO();
                result.setId(result.getId());
                result.setUnitScore(record.getUnitScore());
                result.setUnitScoreLevelStr(result.getUnitScoreLevelStr());
                result.setAnalysisTime(record.getCreateTime());
                results.add(result);
            }

        }

        return results;
    }

    @Override
    public Page<CaseReportWorkBatchVO> caseReportWorkBatch(Page<CaseReportWorkBatchVO> pageData, CaseReportWorkBatchDTO dto) {

        return workBatchService.caseReportWorkBatch(pageData, dto);
    }
}
