package org.jeecg.modules.unitDevice.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
@ApiModel(value = "CaseReportWorkBatchDetailVO对象", description = "单元设备-病例报告作业批次对象")
public class CaseReportWorkBatchDetailVO {

    @ApiModelProperty("主键")
    @TableId("id")
    private String id;

    @ApiModelProperty("工作批次code")
    @TableField("work_batch_code")
    private String workBatchCode;

    @ApiModelProperty("工作批次id")
    @TableField("work_batch_id")
    private String workBatchId;

    @ApiModelProperty("分析批次单元设备id")
    @TableField("analysis_batch_unit_device_id")
    private String analysisBatchUnitDeviceId;

    @ApiModelProperty("单元设备id")
    @TableField("unit_id")
    private String unitId;

    @ApiModelProperty("单元设备code")
    @TableField("unit_code")
    private String unitCode;

    @ApiModelProperty("设备单元类型1-钢轨,2-曲线,3-竖曲线,4-道岔")
    @TableField("unit_type")
    private Integer unitType;

    @ApiModelProperty("设备单元类型名称")
    @TableField("unit_type_name")
    private String unitTypeName;

    @ApiModelProperty("设备编号")
    @TableField("unit_device_code")
    private String unitDeviceCode;

    @ApiModelProperty("设备单元起始里程")
    @TableField("unit_start_mileage")
    private BigDecimal unitStartMileage;

    @ApiModelProperty("设备单元中心里程")
    @TableField("unit_center_mileage")
    private BigDecimal unitCenterMileage;

    @ApiModelProperty("设备单元结束里程")
    @TableField("unit_end_mileage")
    private BigDecimal unitEndMileage;

    @ApiModelProperty("单元得分等级 1-优良 2-合格 3-失格")
    @TableField("unit_score_level")
    private Integer unitScoreLevel;

    @ApiModelProperty("单元得分等级说明")
    @TableField("unit_score_level_str")
    private String unitScoreLevelStr;

    @ApiModelProperty("单元得分")
    @TableField("unit_score")
    private BigDecimal unitScore;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("维修日期")
    private Date maintenanceDate;

}
