package org.jeecg.modules.unitDevice.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
@ApiModel(value = "RailVehicleTqiVO对象", description = "单元设备-病例报告本-轨检车Tqivo")
public class RailVehicleTqiVO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建日期")
    private Date createTime;

    @ApiModelProperty("更新人")
    private String updateBy;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("检查主表id")
    private String checkId;

    @ApiModelProperty("检查主表code")
    private String checkCode;

    @ApiModelProperty("检查数据类型 1-人工静态检查 2-轨检仪静态检查 3-轨检车检查 4-添乘仪检查")
    private Integer checkType;

    @ApiModelProperty("设备单元id")
    private String unitId;

    @ApiModelProperty("设备单元编码")
    private String unitCode;

    @ApiModelProperty("设备单元类型1-钢轨,2-曲线,3-竖曲线,4-道岔")
    private Integer unitType;

    @ApiModelProperty("设备单元类型名称")
    private String unitTypeName;

    @ApiModelProperty("设备单元起始里程")
    private BigDecimal unitStartingMileage;

    @ApiModelProperty("设备单元中心里程")
    private BigDecimal unitCenterMileage;

    @ApiModelProperty("设备单元终点里程")
    private BigDecimal unitEndMileage;

    @ApiModelProperty("tqi报告id")
    private String tqiReportId;

    @ApiModelProperty("开始里程(m)")
    private BigDecimal startMileage;

    @ApiModelProperty("终点里程(m)")
    private BigDecimal endMileage;

    @ApiModelProperty("区间名称")
    private String sectionName;

    @ApiModelProperty("高低左")
    private String highLowLeft;

    @ApiModelProperty("高低右")
    private String highLowRight;

    @ApiModelProperty("轨向左")
    private String trackLeft;

    @ApiModelProperty("轨向右")
    private String trackRight;

    @ApiModelProperty("水平（mm）")
    private String level;

    @ApiModelProperty("轨距（mm）")
    private String trackGauge;

    @ApiModelProperty("三角坑（mm）")
    private String triangularPit;

    @ApiModelProperty("TQI数值")
    private String tqiComeUpon;

    @ApiModelProperty("TQI超标")
    private String tqiAboveStandard;

    @ApiModelProperty("扣分")
    private String deduct;

    @ApiModelProperty("检测标准")
    private String standard;

    @ApiModelProperty("速度（km/h）")
    private String spend;


}
