package org.jeecg.modules.unitDevice.vo;

import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
@ApiModel(value = "LabourCheckVO对象", description = "单元设备-病例报告本-静态检查记录vo")
public class StaticCheckVO {

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建日期")
    private Date createTime;

    @ApiModelProperty("更新人")
    private String updateBy;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("设备单元id")
    private String unitId;

    @ApiModelProperty("设备单元编码")
    private String unitCode;

    @ApiModelProperty("设备单元类型 ")
    private Integer unitType;

    @ApiModelProperty("设备单元类型名称")
    private String unitTypeName;

    @ApiModelProperty("设备单元起始里程")
    private BigDecimal unitStartingMileage;

    @ApiModelProperty("设备单元中心里程")
    private BigDecimal unitCenterMileage;

    @ApiModelProperty("设备单元终点里程")
    private BigDecimal unitEndMileage;

    @ApiModelProperty("检查数据类型 1-人工静态检查 2-轨检仪静态检查 3-轨检车检查 4-添乘仪检查")
    private Integer checkType;

    @ApiModelProperty("检查主表id")
    private String checkId;

    @ApiModelProperty("检查主表Code")
    private String checkCode;

    @ApiModelProperty("检查项目id[注:轨检车是tqi的id]")
    private String checkItemId;

    @ApiModelProperty("检查开始里程 [注:轨检车和添乘仪此id为null]")
    private BigDecimal checkItemStartingMileage;

    @ApiModelProperty("检查结束里程 [注:轨检车和添乘仪此id为null]")
    private BigDecimal checkItemEndMileage;

    @ApiModelProperty("检查文本")
    private String checkItemText;

    @ApiModelProperty("检查详情id")
    private String checkDetailId;

    @ApiModelProperty("检查开始里程")
    private BigDecimal checkDetailStartingMileage;

    @ApiModelProperty("检查结束里程")
    private BigDecimal checkDetailEndMileage;

    @ApiModelProperty("测点")
    private Integer measurePoint;

    @ApiModelProperty("轨距")
    private String trackGauge;

    @ApiModelProperty("水平")
    private String level;

    @ApiModelProperty("三角坑")
    private String triangularPit;

    @ApiModelProperty("方向")
    private String direction;

    @ApiModelProperty("高低")
    private String height;

    @ApiModelProperty("结构")
    private String structure;

    @ApiModelProperty("整改")
    private String rectification;

    @ApiModelProperty("备注")
    private String remark;
}
