package org.jeecg.modules.utils;

import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

/**
 * @author admin
 */
public class ExcelAnalysisUtils {

    /**
     * @Description：获取IO流中的数据，组装成List<List<Object>>对象
     */
    public static List<List<Object>> getListByExcel(InputStream in) throws Exception {
        List<List<Object>> list;

        //创建Excel工作薄
        Workbook work = new XSSFWorkbook(in);
        Sheet sheet;  //页数
        Row row;  //行数
        Cell cell;  //列数

        list = new ArrayList<>();

        //遍历Excel中所有的sheet
        for (int i = 0; i < work.getNumberOfSheets(); i++) {
            sheet = work.getSheetAt(i);
            if (sheet == null) {
                continue;
            }

            //遍历当前sheet中的所有行
            for (int j = sheet.getFirstRowNum(); j <= sheet.getLastRowNum(); j++) {
                row = sheet.getRow(j);
                if (row == null) {
                    continue;
                }

                //遍历所有的列
                List<Object> li = new ArrayList<>();
                for (int y = row.getFirstCellNum(); y < row.getLastCellNum(); y++) {
                    cell = row.getCell(y);
                    li.add(getValue(cell));
                }
                list.add(li);
            }
        }

        return list;

    }
    /**
     * 对表格中数值进行格式化   解决excel类型问题，获得数值
     */
    public static String getValue(Cell cell) {
        String value = "";
        if(null == cell) {
            return value;
        }
        switch(cell.getCellType()) {
            //数值型
            case NUMERIC:
                if(DateUtil.isCellDateFormatted(cell)) {
                    //如果是date类型则 ，获取该cell的date值
                    Date date = DateUtil.getJavaDate(cell.getNumericCellValue());
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                    value = format.format(date);
                }
                else {// 纯数字
                    BigDecimal big = BigDecimal.valueOf(cell.getNumericCellValue());
                    String s = "0";
                    value = big.toString();
                    //解决1234.0  去掉后面的.0
                    if(null != value && !"".equals(value.trim())) {
                        String[] item = value.split("[.]");
                        if(1 < item.length && s.equals(item[1])) {
                            value = item[0];
                        }
                    }
                }
                break;
            //字符串类型
            case STRING:
                value = cell.getStringCellValue();
                break;
            // 公式类型
            case FORMULA:
                //读公式计算值
                value = String.valueOf(cell.getNumericCellValue());
                String nan = "NaN";
                if(nan.equals(value)) {// 如果获取的数据值为非法值,则转换为获取字符串
                    value = cell.getStringCellValue();
                }
                break;
            // 布尔类型
            case BOOLEAN:
                value = " " + cell.getBooleanCellValue();
                break;
            default:
                value = cell.getStringCellValue();
        }
        String ss = "null";
        if(ss.endsWith(value.trim())) {
            value = "";
        }
        return value;
    }
}
