package org.jeecg.modules.utils;

import cn.hutool.extra.pinyin.PinyinUtil;
import org.jeecg.modules.deviceAsset.entity.*;
import org.jeecg.modules.deviceAsset.service.*;
import org.jeecg.modules.subwayNetwork.entity.LineAlias;
import org.jeecg.modules.subwayNetwork.service.ILineAliasService;

/**
 * @describe:单元编码生成工具
 */
public class UnitCodeUtil {

    private static ILineAliasService lineAliasService;

    private static ISwitchManagementService switchManagementService;

    private static ICurveManagementService curveManagementService;

    private static IVerticalCurveManagementService verticalCurveManagementService;

    private static IRailManagementService railManagementService;

    private static ITrackBedManagementService trackBedManagementService;

    private static ISleeperManagementService sleeperManagementService;

    private static IFastenerManagementService fastenerManagementService;

    public static void setService(ILineAliasService lineAliasService,
                                  ISwitchManagementService switchManagementService,
                                  ICurveManagementService curveManagementService,
                                  IVerticalCurveManagementService verticalCurveManagementService,
                                  IRailManagementService railManagementService,
                                  ITrackBedManagementService trackBedManagementService,
                                  ISleeperManagementService sleeperManagementService,
                                  IFastenerManagementService fastenerManagementService) {
        UnitCodeUtil.lineAliasService = lineAliasService;
        UnitCodeUtil.switchManagementService = switchManagementService;
        UnitCodeUtil.curveManagementService = curveManagementService;
        UnitCodeUtil.verticalCurveManagementService = verticalCurveManagementService;
        UnitCodeUtil.railManagementService = railManagementService;
        UnitCodeUtil.trackBedManagementService = trackBedManagementService;
        UnitCodeUtil.sleeperManagementService = sleeperManagementService;
        UnitCodeUtil.fastenerManagementService = fastenerManagementService;
    }

    /**
     * 钢轨单元编码:线别码+GG+流水号(5位流水号)
     * 实例:SXXGG00001
     * GG - 钢轨编码
     * 0001-流水号
     *
     * @param lineId 线别ID
     */
    public static String railUnitCodeUtil(String lineId) {
        // 获取线别拼音
        LineAlias lineAlias = lineAliasService.getById(lineId);
        String lineAliasPinyin = PinyinUtil.getFirstLetter(lineAlias.getLineAliasName(), "").toUpperCase();


        // 查询最大的编号
        String unitCode = lineAliasPinyin + "GG";
        RailManagement record = railManagementService.lambdaQuery()
                .likeRight(RailManagement::getUnitCode, unitCode)
                .orderByDesc(RailManagement::getUnitCode)
                .last("limit 1")
                .one();


        // 流水号初始化为1
        Integer serialNum = 1;
        if (null != record && record.getUnitCode() != null) {
            // 流水号+1
            serialNum = Integer.parseInt(record.getUnitCode().substring(record.getUnitCode().length() - 4)) + 1;
        }
        String serialNumStr = supplementZero(4, serialNum);

        return unitCode + serialNumStr;
    }

    /**
     * SQX - 竖曲线
     * 0001-流水号
     *
     * @param lineId 线别ID
     */
    public static String verticalCurveUnitCodeUtil(String lineId) {
        // 获取线别拼音
        LineAlias lineAlias = lineAliasService.getById(lineId);
        String lineAliasPinyin = PinyinUtil.getFirstLetter(lineAlias.getLineAliasName(), "").toUpperCase();


        // 查询最大的编号
        String unitCode = lineAliasPinyin + "SQX";
        VerticalCurveManagement record = verticalCurveManagementService.lambdaQuery()
                .likeRight(VerticalCurveManagement::getUnitCode, unitCode)
                .orderByDesc(VerticalCurveManagement::getUnitCode)
                .last("limit 1")
                .one();


        // 流水号初始化为1
        Integer serialNum = 1;
        if (null != record && record.getUnitCode() != null) {
            // 流水号+1
            serialNum = Integer.parseInt(record.getUnitCode().substring(record.getUnitCode().length() - 4)) + 1;
        }
        String serialNumStr = supplementZero(4, serialNum);

        return unitCode + serialNumStr;
    }

    /**
     * 曲线代码生成: L201QX0001
     * QX - 曲线
     * 000001-流水号
     *
     * @param lineId 线别ID
     */
    public static String curveUnitCodeUtil(String lineId) {
        // 获取线别拼音
        LineAlias lineAlias = lineAliasService.getById(lineId);
        String lineAliasPinyin = PinyinUtil.getFirstLetter(lineAlias.getLineAliasName(), "").toUpperCase();


        // 查询最大的编号
        String unitCode = lineAliasPinyin + "QX";
        CurveManagement record = curveManagementService.lambdaQuery()
                .likeRight(CurveManagement::getUnitCode, unitCode)
                .orderByDesc(CurveManagement::getUnitCode)
                .last("limit 1")
                .one();

        // 流水号初始化为1
        Integer serialNum = 1;
        if (null != record && record.getUnitCode() != null) {
            // 流水号+1
            serialNum = Integer.parseInt(record.getUnitCode().substring(record.getUnitCode().length() - 4)) + 1;
        }
        String serialNumStr = supplementZero(4, serialNum);

        return unitCode + serialNumStr;
    }

    /**
     * 道岔代码生成: 01DC0001
     * 01 - 上行;02-表示下行
     * DC - 道岔
     * 000001-流水号
     *
     * @param lineId 线别ID
     */
    public static String switchUnitCodeUtil(String lineId) {
        // 获取线别拼音
        LineAlias lineAlias = lineAliasService.getById(lineId);
        String lineAliasPinyin = PinyinUtil.getFirstLetter(lineAlias.getLineAliasName(), "").toUpperCase();


        // 查询最大的编号
        String unitCode = lineAliasPinyin + "DC";
        SwitchManagement record = switchManagementService.lambdaQuery()
                .likeRight(SwitchManagement::getUnitCode, unitCode)
                .orderByDesc(SwitchManagement::getUnitCode)
                .last("limit 1")
                .one();

        // 流水号初始化为1
        Integer serialNum = 1;
        if (null != record && record.getUnitCode() != null) {
            // 流水号+1
            serialNum = Integer.parseInt(record.getUnitCode().substring(record.getUnitCode().length() - 4)) + 1;
        }
        String serialNumStr = supplementZero(4, serialNum);

        return unitCode + serialNumStr;
    }

//------------------------------shizhilong---------------------------------------

    /**
     * 道床编码:线别码+DC+流水号(5位流水号)
     * 实例:SXXDC00001
     * DC - 道床编码
     * 0001-流水号
     *
     * @param lineId 线别ID
     */
    public static String trackBedManagementUtil(String lineId) {
        // 获取线别拼音
        LineAlias lineAlias = lineAliasService.getById(lineId);
        String lineAliasPinyin = PinyinUtil.getFirstLetter(lineAlias.getLineAliasName(), "").toUpperCase();


        // 查询最大的编号
        String trackBedCode = lineAliasPinyin + "DC";
        TrackBedManagement record = trackBedManagementService.lambdaQuery()
                .likeRight(TrackBedManagement::getTrackBedCode, trackBedCode)
                .orderByDesc(TrackBedManagement::getTrackBedCode)
                .last("limit 1")
                .one();


        // 流水号初始化为1
        Integer serialNum = 1;
        if (null != record && record.getTrackBedCode() != null) {
            // 流水号+1
            serialNum = Integer.parseInt(record.getTrackBedCode().substring(record.getTrackBedCode().length() - 4)) + 1;
        }
        String serialNumStr = supplementZero(4, serialNum);

        return trackBedCode + serialNumStr;
    }

    /**
     * 轨枕编码:线别码+GZ+流水号(5位流水号)
     * 实例:SXXGZ00001
     * GZ - 轨枕编码
     * 0001-流水号
     *
     * @param lineId 线别ID
     */
    public static String sleeperManagementUtil(String lineId) {
        // 获取线别拼音
        LineAlias lineAlias = lineAliasService.getById(lineId);
        String lineAliasPinyin = PinyinUtil.getFirstLetter(lineAlias.getLineAliasName(), "").toUpperCase();


        // 查询最大的编号
        String code = lineAliasPinyin + "GZ";
        SleeperManagement record = sleeperManagementService.lambdaQuery()
                .likeRight(SleeperManagement::getSleeperCode, code)
                .orderByDesc(SleeperManagement::getSleeperCode)
                .last("limit 1")
                .one();


        // 流水号初始化为1
        Integer serialNum = 1;
        if (null != record && record.getSleeperCode() != null) {
            // 流水号+1
            serialNum = Integer.parseInt(record.getSleeperCode().substring(record.getSleeperCode().length() - 4)) + 1;
        }
        String serialNumStr = supplementZero(4, serialNum);

        return code + serialNumStr;
    }
    /**
     * 扣件编码:线别码+KJ+流水号(5位流水号)
     * 实例:SXXKJ00001
     * KJ - 扣件编码
     * 0001-流水号
     *
     * @param lineId 线别ID
     */
    public static String fastenerManagementUtil(String lineId) {
        // 获取线别拼音
        LineAlias lineAlias = lineAliasService.getById(lineId);
        String lineAliasPinyin = PinyinUtil.getFirstLetter(lineAlias.getLineAliasName(), "").toUpperCase();


        // 查询最大的编号
        String code = lineAliasPinyin + "KJ";
        FastenerManagement record = fastenerManagementService.lambdaQuery()
                .likeRight(FastenerManagement::getFastenerCode, code)
                .orderByDesc(FastenerManagement::getFastenerCode)
                .last("limit 1")
                .one();


        // 流水号初始化为1
        Integer serialNum = 1;
        if (null != record && record.getFastenerCode() != null) {
            // 流水号+1
            serialNum = Integer.parseInt(record.getFastenerCode().substring(record.getFastenerCode().length() - 4)) + 1;
        }
        String serialNumStr = supplementZero(4, serialNum);
        return code + serialNumStr;
    }
    /**
     * 将元数据前补零，补后的总长度为指定的长度，以宇符串的形式返回
     *
     * @param numLength 字符总长度
     * @param num       转值的数量
     */
    public static String supplementZero(int numLength, int num) {
        return String.format("%0" + numLength + "d", num);
    }

}