package org.jeecg.modules.checkData.controller;


import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.modules.checkData.entity.RailInspectionEquipmentItem;
import org.jeecg.modules.checkData.entity.RailInspectionEquipmentItemDetail;
import org.jeecg.modules.checkData.service.IRailInspectionEquipmentItemDetailService;
import org.jeecg.modules.checkData.service.IRailInspectionEquipmentItemService;
import org.jeecg.modules.checkData.vo.RailInspectionEquipmentItemDetailVO;
import org.jeecg.modules.checkData.vo.RailInspectionEquipmentItemVO;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 检查数据-动静态几何尺寸数据-轨检仪静态检查数据-检查项目 前端控制器
 * </p>
 *
 * @author hkl
 * @since 2023-07-16
 */
@RestController
@RequestMapping("/checkData/dynamicStaticGeometricData/railInspectionEquipmentItem")
@Api(tags = "检查数据-动静态几何尺寸数据-轨检仪静态检查数据-检查项目")
public class RailInspectionEquipmentItemController extends JeecgController<RailInspectionEquipmentItem, IRailInspectionEquipmentItemService> {

    @Resource
    private IRailInspectionEquipmentItemDetailService railInspectionEquipmentItemDetailService;

    @AutoLog(value = "检查数据-动静态几何尺寸数据-轨检仪静态检查数据-项目列表查询")
    @ApiOperation(value = "检查数据-动静态几何尺寸数据-轨检仪静态检查数据-项目列表查询", notes = "检查数据-动静态几何尺寸数据-轨检仪静态检查数据-项目列表查询")
    @GetMapping(value = "/list")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "轨检仪静态检查数据id")
    })
    public Result<List<RailInspectionEquipmentItemVO>> queryList(String id) {
        List<RailInspectionEquipmentItemVO> record = this.service.queryList(id);
        return Result.OK(record);
    }


    @AutoLog(value = "检查数据-动静态几何尺寸数据-轨检仪静态检查数据-保存")
    @ApiOperation(value = "检查数据-动静态几何尺寸数据-轨检仪静态检查数据-保存", notes = "检查数据-动静态几何尺寸数据-轨检仪静态检查数据-保存")
    @PostMapping(value = "/saveRecord")
    public Result<String> saveRecord(@RequestBody RailInspectionEquipmentItem record) {

        this.service.saveRecord(record);

        return Result.OK("保存成功");
    }


    @AutoLog(value = "检查数据-动静态几何尺寸数据-轨检仪静态检查数据-编辑")
    @ApiOperation(value = "检查数据-动静态几何尺寸数据-轨检仪静态检查数据-编辑", notes = "检查数据-动静态几何尺寸数据-轨检仪静态检查数据-编辑")
    @PostMapping(value = "/updateRecord")
    public Result<String> updateRecord(@RequestBody RailInspectionEquipmentItem record) {

        this.service.updateRecord(record);

        return Result.OK("保存成功");
    }

    @AutoLog(value = "检查数据-动静态几何尺寸数据-轨检仪静态检查数据-删除")
    @ApiOperation(value = "检查数据-动静态几何尺寸数据-轨检仪静态检查数据-编辑", notes = "检查数据-动静态几何尺寸数据-轨检仪静态检查数据-删除")
    @GetMapping(value = "/deleteRecord")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "轨检仪静态检查项目id")
    })
    public Result<String> deleteRecord(String id) {

        this.service.deleteRecord(id);

        return Result.OK("保存成功");
    }

    @AutoLog(value = "检查数据-动静态几何尺寸数据-轨检仪静态检查数据-项目明细列表")
    @ApiOperation(value = "检查数据-动静态几何尺寸数据-轨检仪静态检查数据-项目明细列表", notes = "检查数据-动静态几何尺寸数据-轨检仪静态检查数据-项目明细列表")
    @GetMapping(value = "/detailList")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "itemId", value = "轨检仪静态检查项目id")
    })
    public Result<List<RailInspectionEquipmentItemDetailVO>> detailList(String itemId) {
        List<RailInspectionEquipmentItemDetailVO> record = this.service.detailList(itemId);
        return Result.OK(record);
    }

    @AutoLog(value = "检查数据-动静态几何尺寸数据-轨检仪静态检查数据-项目明细更新")
    @ApiOperation(value = "检查数据-动静态几何尺寸数据-轨检仪静态检查数据-项目明细更新", notes = "检查数据-动静态几何尺寸数据-轨检仪静态检查数据-项目明细更新")
    @PostMapping(value = "/detailUpdateRecord")
    public Result<String> detailUpdateRecord(@RequestBody RailInspectionEquipmentItemDetail record) {

        railInspectionEquipmentItemDetailService.lambdaUpdate()
                .set(RailInspectionEquipmentItemDetail::getTrackGauge, record.getTrackGauge()) // 轨距
                .set(RailInspectionEquipmentItemDetail::getLevel, record.getLevel()) // 水平
                .set(RailInspectionEquipmentItemDetail::getTriangularPit, record.getTriangularPit()) // 三角坑
                .set(RailInspectionEquipmentItemDetail::getOther, record.getOther()) // 轨向、高低及其它
                .set(RailInspectionEquipmentItemDetail::getUpdateTime, new Date())
                .eq(RailInspectionEquipmentItemDetail::getId, record.getId())
                .update();

        return Result.OK("操作成功");
    }


    @PostMapping(value = "/upload")
    @AutoLog(value = "检查数据-动静态几何尺寸数据-轨检仪静态检查数据-导入")
    @ApiOperation(value = "检查数据-动静态几何尺寸数据-轨检仪静态检查数据-导入", notes = "检查数据-动静态几何尺寸数据-轨检仪静态检查数据-导入")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "轨检仪静态检查数据id"),
            @ApiImplicitParam(name = "file", value = "文件"),
    })
    public Result<String> uploadFile(String id, MultipartFile file) {

        this.service.uploadFile(id, file);

        return Result.ok("操作成功");
    }
}
