package org.jeecg.modules.checkData.controller;


import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.modules.checkData.dto.RecordPatrolMasterDTO;
import org.jeecg.modules.checkData.entity.*;
import org.jeecg.modules.checkData.service.IRecordPatrolMasterAssistService;
import org.jeecg.modules.checkData.service.IRecordPatrolMasterInfoService;
import org.jeecg.modules.checkData.service.IRecordPatrolMasterService;
import org.jeecg.modules.checkData.vo.*;
import org.jeecg.modules.utils.BeanCopyUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.jeecg.common.system.base.controller.JeecgController;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * <p>
 * 线路巡查记录主表-巡道员使用 前端控制器
 * </p>
 *
 * @author hkl
 * @since 2023-07-08
 */
@RestController
@RequestMapping("/patrol/master")
@Api(tags = "线路巡查记录相关")
public class RecordPatrolMasterController extends JeecgController<RecordPatrolMaster, IRecordPatrolMasterService> {
    @Autowired
    private IRecordPatrolMasterInfoService recordPatrolMasterInfoService;

    @Autowired
    private IRecordPatrolMasterAssistService recordPatrolMasterAssistService;

    /**
     * 线路巡查记录-分页列表查询
     *
     * @param pageNo
     * @param pageSize
     * @param dto
     * @return
     */
    @AutoLog(value = "线路巡查记录-分页列表查询")
    @ApiOperation(value = "线路巡查记录-分页列表查询", notes = "线路巡查记录-分页列表查询")
    @GetMapping(value = "/list")
    public Result<IPage<RecordPatrolMasterVO>> queryPageList(@RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                                             @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                                             RecordPatrolMasterDTO dto) {
        Page<RecordPatrolMasterVO> pageData = new Page<>(pageNo, pageSize);
        pageData = this.service.queryPageList(pageData, dto);
        return Result.OK(pageData);
    }

    /**
     * 根据线路巡查记录id查询详情
     *
     * @param id 线路巡查记录id
     * @return
     */
    @AutoLog(value = "根据线路巡查记录id查询详情")
    @ApiOperation(value = "根据线路巡查记录id查询详情", notes = "根据线路巡查记录id查询详情")
    @GetMapping(value = "/getInfoById")
    public Result<List<RecordPatrolMasterInfoOneVO>> getInfoById(@ApiParam(name = "线路巡查记录id") String id) {
        List<RecordPatrolMasterInfo> listResult = recordPatrolMasterInfoService.lambdaQuery()
                .eq(ObjectUtil.isNotEmpty(id), RecordPatrolMasterInfo::getRecordMasterId, id)
                .eq(RecordPatrolMasterInfo::getDelFlag, "0")
                .orderByAsc(RecordPatrolMasterInfo::getSeq)
                .list();

        //初始化最终返回的集合
        List<RecordPatrolMasterInfoOneVO> resultList = new ArrayList<>();
        if (listResult != null && listResult.size() > 0) {
            //获取去重后的项目名称的集合
            Set<String> progectNameList = listResult.stream().map(RecordPatrolMasterInfo::getEkProjectName).collect(Collectors.toSet());
            for (String name : progectNameList) {
                //初始化最终返回的对象
                RecordPatrolMasterInfoOneVO resultModel = new RecordPatrolMasterInfoOneVO();
                //初始化检查项目对应的详情记录的集合
                List<RecordPatrolMasterInfoVO> infoList = new ArrayList<>();
                //循环符合条件的数据项集合
                for (RecordPatrolMasterInfo entity : listResult) {
                    //判断项目名称一样
                    if (name.equals(entity.getEkProjectName())) {
                        //初始化检查项目对应的详情记录的对象
                        RecordPatrolMasterInfoVO infoVo = new RecordPatrolMasterInfoVO();
                        BeanCopyUtil.copyProperties(entity, infoVo);
                        infoList.add(infoVo);
                    }
                }
                resultModel.setInfoList(infoList);
                resultModel.setEkProjectName(name);
                resultList.add(resultModel);
            }
        }
        return Result.OK(resultList);
    }

    /**
     * 根据线路巡查记录id查询协助详情
     *
     * @param id 线路巡查记录id
     * @return
     */
    @AutoLog(value = "根据线路巡查记录id查询协助详情")
    @ApiOperation(value = "根据线路巡查记录id查询协助详情", notes = "根据线路巡查记录id查询协助详情")
    @GetMapping(value = "/getAssistInfo")
    public Result<List<RecordPatrolMasterAssistVO>> getAssistInfo(@ApiParam(name = "线路巡查记录id") String id) {
        List<RecordPatrolMasterAssist> listResult = recordPatrolMasterAssistService.lambdaQuery()
                .eq(ObjectUtil.isNotEmpty(id), RecordPatrolMasterAssist::getRecordMasterId, id)
                .eq(RecordPatrolMasterAssist::getDelFlag, "0")
                .orderByAsc(RecordPatrolMasterAssist::getCreateTime)
                .list();
        List<RecordPatrolMasterAssistVO> resultList = new ArrayList<>();
        if (listResult != null) {
            resultList = BeanCopyUtil.copyListProperties(listResult, RecordPatrolMasterAssistVO::new);
        }
        return Result.OK(resultList);
    }

    /**
     * 线路巡查记录导出excel
     *
     * @param request
     * @param recordPatrolMaster 线路巡查记录
     * @return
     */
    @AutoLog(value = "线路巡查记录导出excel")
    @ApiOperation(value = "线路巡查记录导出excel", notes = "线路巡查记录导出excel")
    @GetMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, RecordPatrolMaster recordPatrolMaster) {
        return super.exportXls(request, recordPatrolMaster, RecordPatrolMaster.class, "线路巡查记录情况");
    }
}
