package org.jeecg.modules.checkData.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 动静态几何尺寸对应得里程相关信息详情表
 * </p>
 *
 * @author hkl
 * @since 2023-07-11
 */
@Data
public class MovementCourseInfoDTO {


    private static final long serialVersionUID = 1L;

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("创建人")
    private String createBy;

    @ApiModelProperty("创建日期")
    private Date createTime;

    @ApiModelProperty("更新人")
    private String updateBy;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("动静态几何尺寸数据主表主键-》外键")
    private String movementMasterId;

    @ApiModelProperty("动静态几何尺寸对应得里程信息主键-》外键")
    private String movementCourseId;

    @ApiModelProperty("轨号")
    private String trackCode;

    @ApiModelProperty("测点")
    private Integer measurePoint;

    @ApiModelProperty("轨距")
    private String trackGauge;

    @ApiModelProperty("水平")
    private String level;

    @ApiModelProperty("三角坑")
    private String triangularPit;

    @ApiModelProperty("方向")
    private String direction;

    @ApiModelProperty("高低")
    private String height;

    @ApiModelProperty("结构")
    private String structure;

    @ApiModelProperty("整改")
    private String rectification;

    @ApiModelProperty("是否删除（0：未删除；1：已删除）")
    private String delFlag;

    @ApiModelProperty("导入顺序")
    private Integer infoSort;
}
